/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.ide.util.AddinPolicyUtils;
import oracle.ide.util.Assert;
import oracle.javatools.util.PlatformUtils;

public final class GraphicsUtils {
    private static final Logger LOGGER = Logger.getLogger(GraphicsUtils.class.getName());
    private static final Insets HIGHLIGHT_INSETS = new Insets(1, 1, 1, 1);
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static Hashtable imageCache = new Hashtable();
    private static final String[] m_ImageExtensions = !PlatformUtils.isCaseSensitiveFileSystem() ? new String[]{".gif", ".jpg", ".jpeg", ".png"} : new String[]{".gif", ".GIF", ".jpg", ".JPG", ".jpeg", ".JPEG", ".png", ".PNG"};

    private GraphicsUtils() {
    }

    public static void drawHighlightBorder(Graphics g, int x, int y, int width, int height, boolean raised, Color shadow, Color highlight) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(raised ? highlight : shadow);
        g.drawLine(0, 0, width - 2, 0);
        g.drawLine(0, 1, 0, height - 2);
        g.setColor(raised ? shadow : highlight);
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.drawLine(0, height - 1, width - 2, height - 1);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public static Insets getHighlightBorderInsets() {
        return HIGHLIGHT_INSETS;
    }

    public static ImageIcon createImageIcon(URL url) {
        if (url == null) {
            return null;
        }
        return GraphicsUtils.createImageIcon(Toolkit.getDefaultToolkit().createImage(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon createImageIcon(Image image) {
        if (image == null) {
            return null;
        }
        AddinPolicyUtils.creatingImageIconPolicyCheck();
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, 0);
        }
        return new ImageIcon(image);
    }

    public static Image createImage(Component component, int width, int height) {
        if (width <= 0 || height <= 0) {
            return null;
        }
        try {
            return component.createImage(width, height);
        }
        catch (OutOfMemoryError oomError) {
            return null;
        }
    }

    public static Point getPopupMenuShowPoint(JPopupMenu popup, MouseEvent event) {
        Component source = (Component)event.getSource();
        Point topLeftSource = source.getLocationOnScreen();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("source component " + source.getClass().getName() + " top-left point on screen = " + topLeftSource);
        }
        Point ptRet = GraphicsUtils.getPopupMenuShowPoint(popup, topLeftSource.x + event.getX(), topLeftSource.y + event.getY());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("popup menu show point = " + ptRet);
        }
        ptRet.translate(-topLeftSource.x, -topLeftSource.y);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("adjusted point = " + ptRet);
        }
        return ptRet;
    }

    public static Point getPopupMenuShowPoint(JPopupMenu popup, int x, int y) {
        Dimension sizeMenu = popup.getPreferredSize();
        Point bottomRightMenu = new Point(x + sizeMenu.width, y + sizeMenu.height);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("popup menu preferred size = " + sizeMenu + "; bottom right point = " + bottomRightMenu);
        }
        for (Rectangle screenBounds : GraphicsUtils.getScreenBounds()) {
            if (screenBounds.x > x || x > screenBounds.x + screenBounds.width) continue;
            Dimension sizeScreen = screenBounds.getSize();
            sizeScreen.height -= 32;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("screen size = " + sizeScreen);
            }
            int xOffset = 0;
            if (bottomRightMenu.x > screenBounds.x + sizeScreen.width) {
                xOffset = -sizeMenu.width;
            }
            int yOffset = 0;
            if (bottomRightMenu.y > screenBounds.y + sizeScreen.height) {
                yOffset = sizeScreen.height - bottomRightMenu.y;
            }
            if ((xOffset != 0 || yOffset != 0) && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("non-zero offset indicates popup point was adjusted to ensure it doesn't extend beyond the display rectangle; xOffset = " + xOffset + " yOffset = " + yOffset);
            }
            return new Point(x + xOffset, y + yOffset);
        }
        return new Point(x, y);
    }

    public static void centerWindowOnComponent(Window window, Component over) {
        if (over == null || !over.isShowing()) {
            GraphicsUtils.centerWindowOnScreen(window);
            return;
        }
        Point parentLocation = over.getLocationOnScreen();
        Dimension parentSize = over.getSize();
        Dimension size = window.getSize();
        int x = parentLocation.x + (parentSize.width - size.width) / 2;
        int y = parentLocation.y + (parentSize.height - size.height) / 2;
        Rectangle[] screenBounds = GraphicsUtils.getScreenBounds();
        Point ptCenter = new Point(x + size.width, y + size.height);
        for (int i = 0; i < screenBounds.length; ++i) {
            Rectangle screenBound = screenBounds[i];
            if (!screenBound.contains(ptCenter)) continue;
            if (x + size.width > screenBound.width) {
                x = screenBound.width - size.width;
            }
            if (x < screenBound.x) {
                x = screenBound.x;
            }
            if (y + size.height > screenBound.height) {
                y = screenBound.height - size.height;
            }
            if (y >= screenBound.y) break;
            y = screenBound.y;
            break;
        }
        window.setLocation(x, y);
    }

    public static boolean isAncestorOfFocusedComponent(Component c) {
        Component focusedChildComponent = GraphicsUtils.getFocusedChildComponent(c);
        return focusedChildComponent != null;
    }

    public static Component getFocusedChildComponent(Component c) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getPermanentFocusOwner();
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, c)) {
            return focusOwner;
        }
        return null;
    }

    @Deprecated
    public static Component getFocusableComponentOrChild(Component c) {
        return GraphicsUtils.getFocusableComponentOrChild(c, false);
    }

    public static JComponent getFocusableComponentOrChild(Component c, boolean deepest) {
        if (c != null && c.isEnabled() && c.isVisible() && c instanceof JComponent) {
            JComponent jcomp = (JComponent)c;
            if (!deepest && jcomp.isFocusable() && jcomp.isRequestFocusEnabled() && !jcomp.getClass().getName().equals("javax.swing.JPanel")) {
                return jcomp;
            }
            int n = jcomp.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component child = jcomp.getComponent(i);
                JComponent focused = GraphicsUtils.getFocusableComponentOrChild(child, deepest);
                if (focused == null) continue;
                return focused;
            }
            if (deepest && jcomp.isFocusable() && jcomp.isRequestFocusEnabled() && !jcomp.getClass().getName().equals("javax.swing.JPanel")) {
                return jcomp;
            }
        }
        return null;
    }

    public static Component focusComponentOrChild(Component c) {
        return GraphicsUtils.focusComponentOrChild(c, false);
    }

    public static JComponent focusComponentOrChild(Component c, boolean deepest) {
        JComponent ret = null;
        JComponent focusable = GraphicsUtils.getFocusableComponentOrChild(c, deepest);
        if (focusable != null && focusable.requestFocusInWindow()) {
            ret = focusable;
        }
        return ret;
    }

    public static Image loadFromResource(String imageName, Class cls) {
        try {
            URL url = cls.getResource(imageName);
            if (url == null) {
                return null;
            }
            Image image = (Image)imageCache.get(url.toString());
            if (image == null) {
                image = Toolkit.getDefaultToolkit().createImage(url);
                imageCache.put(url.toString(), image);
            }
            return image;
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return null;
        }
    }

    public static Point computePopupLocation(JComponent popup, JComponent parent) {
        Rectangle screenBounds = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration gc = parent.getGraphicsConfiguration();
        screenBounds = gc != null ? gc.getBounds() : new Rectangle(new Point(), toolkit.getScreenSize());
        Insets screenInsets = toolkit.getScreenInsets(gc);
        screenBounds.width -= screenInsets.left + screenInsets.right;
        screenBounds.height -= screenInsets.top + screenInsets.bottom;
        screenBounds.x += screenInsets.left;
        screenBounds.y += screenInsets.top;
        Rectangle r = new Rectangle(parent.getLocationOnScreen(), popup.getPreferredSize());
        int overrun = r.x - screenBounds.x + r.width - screenBounds.width;
        if (overrun > 0) {
            r.x -= overrun;
        }
        if (r.x < screenBounds.x) {
            r.x = screenBounds.x;
        }
        r.y = r.y + r.height > screenBounds.height ? (r.y -= r.height) : (r.y += parent.getHeight());
        overrun = r.y - screenBounds.y + r.height - screenBounds.height;
        if (overrun > 0) {
            r.y -= overrun;
        }
        if (r.y < screenBounds.y) {
            r.y = screenBounds.y;
        }
        Point boundsLocation = r.getLocation();
        SwingUtilities.convertPointFromScreen(boundsLocation, parent);
        r.setLocation(boundsLocation);
        return r.getLocation();
    }

    public static Rectangle[] getScreenBounds() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = graphicsEnvironment.getScreenDevices();
        Rectangle[] ret = new Rectangle[screenDevices.length];
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("number of devices found = " + screenDevices.length);
        }
        for (int i = 0; i < screenDevices.length; ++i) {
            GraphicsDevice screenDevice = screenDevices[i];
            GraphicsConfiguration defaultConfiguration = screenDevice.getDefaultConfiguration();
            Rectangle screenBounds = defaultConfiguration.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(defaultConfiguration);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            screenBounds.x += Math.abs(screenInsets.left);
            screenBounds.y += Math.abs(screenInsets.top);
            ret[i] = screenBounds;
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("device id = " + screenDevice.getIDstring());
            LOGGER.fine("screen insets = " + screenInsets);
            LOGGER.fine("screen bounds = " + screenBounds);
        }
        return ret;
    }

    public static String[] getImageExtensions() {
        return m_ImageExtensions;
    }

    public static void centerWindowOnScreen(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = window.getSize();
        if (size.height > screenSize.height) {
            size.height = screenSize.height;
        }
        if (size.width > screenSize.width) {
            size.width = screenSize.width;
        }
        window.setLocation((screenSize.width - size.width) / 2, (screenSize.height - size.height) / 2);
    }

    public static void setWindowOpacity(Window window, float opacity) {
        try {
            if (window.getGraphicsConfiguration().isTranslucencyCapable()) {
                window.setOpacity(opacity);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

