/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.text;

import java.awt.Color;
import java.awt.Font;
import oracle.ide.print.misc.Config;

final class Symbol {
    private char myChar;
    private Font myFont;
    private Color myColor;
    public static final Symbol SPACE = new Symbol(' ', Config.DEFAULT_TEXT_FONT, Color.black);

    Symbol(char c, Font font, Color color) {
        this.myChar = c;
        this.myFont = font;
        this.myColor = color;
    }

    char getChar() {
        return this.myChar;
    }

    Font getFont() {
        return this.myFont;
    }

    Color getColor() {
        return this.myColor;
    }

    public String toString() {
        return "'" + this.myChar + "' " + this.getString(this.myFont) + " " + this.getString(this.myColor);
    }

    private String getString(Color color) {
        return "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
    }

    private String getString(Font font) {
        String style = "";
        if (font.isBold()) {
            style = style + "bold";
        }
        style = font.isItalic() ? style + " italic" : style + " plain";
        return "[" + font.getName() + ", " + style + ", " + font.getSize() + "]";
    }
}

