/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class Attributes
implements AttributedCharacterIterator {
    private int myCurrent = -1;
    private List<Font> myFonts;
    private List<Color> myColors;
    private List<Integer> myRunStart = new ArrayList<Integer>();
    private List<Integer> myRunLimit;
    private List<Character> myChars;
    private Set<AttributedCharacterIterator.Attribute> myKeys;

    Attributes() {
        this.myRunStart.add(0);
        this.myRunLimit = new ArrayList<Integer>();
        this.myRunLimit.add(0);
        this.myChars = new ArrayList<Character>();
        this.myFonts = new ArrayList<Font>();
        this.myColors = new ArrayList<Color>();
        HashSet<TextAttribute> set = new HashSet<TextAttribute>();
        set.add(TextAttribute.FONT);
        set.add(TextAttribute.FOREGROUND);
        this.myKeys = Collections.unmodifiableSet(set);
    }

    void add(char ch, Font font, Color color) {
        if (font == null) {
            return;
        }
        ++this.myCurrent;
        this.myChars.add(Character.valueOf(ch));
        this.myFonts.add(font);
        this.myColors.add(color);
        if (this.myCurrent != 0) {
            int prev = this.myCurrent - 1;
            if (this.myFonts.get(prev).equals(font) && this.myColors.get(prev).equals(color)) {
                int index = this.myRunStart.get(prev);
                this.myRunStart.add(this.myCurrent, index);
                this.myRunLimit.add(index, this.myCurrent);
            } else {
                this.myRunLimit.add(this.myCurrent, this.myCurrent);
                this.myRunStart.add(this.myCurrent, this.myCurrent);
            }
        }
    }

    AttributedCharacterIterator iterator() {
        return this;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public char current() {
        if (this.myCurrent >= this.myChars.size()) {
            return '\uffff';
        }
        return this.myChars.get(this.myCurrent).charValue();
    }

    @Override
    public char first() {
        this.myCurrent = 0;
        if (this.myCurrent >= this.myChars.size()) {
            return '\uffff';
        }
        return this.myChars.get(this.myCurrent).charValue();
    }

    @Override
    public int getBeginIndex() {
        return 0;
    }

    @Override
    public int getEndIndex() {
        return this.myChars.size();
    }

    @Override
    public int getIndex() {
        return this.myCurrent;
    }

    @Override
    public char last() {
        int end = this.getEndIndex();
        if (end == 0) {
            return '\uffff';
        }
        this.myCurrent = end - 1;
        return this.myChars.get(this.myCurrent).charValue();
    }

    @Override
    public char next() {
        if (this.myCurrent >= this.getEndIndex() - 1) {
            return '\uffff';
        }
        return this.myChars.get(++this.myCurrent).charValue();
    }

    @Override
    public char previous() {
        if (this.myCurrent == 0) {
            return '\uffff';
        }
        return this.myChars.get(--this.myCurrent).charValue();
    }

    @Override
    public char setIndex(int i) {
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        if (i == this.getEndIndex()) {
            this.myCurrent = i;
            return '\uffff';
        }
        this.myCurrent = i;
        return this.myChars.get(this.myCurrent).charValue();
    }

    @Override
    public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
        return this.myKeys;
    }

    @Override
    public Object getAttribute(AttributedCharacterIterator.Attribute att) {
        if (att == TextAttribute.FONT) {
            return this.myFonts.get(this.getIndex());
        }
        if (att == TextAttribute.FOREGROUND) {
            return this.myColors.get(this.getIndex());
        }
        return null;
    }

    @Override
    public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
        HashMap<AttributedCharacterIterator.Attribute, Object> map = new HashMap<AttributedCharacterIterator.Attribute, Object>(1);
        map.put(TextAttribute.FONT, this.myFonts.get(this.getIndex()));
        map.put(TextAttribute.FOREGROUND, this.myColors.get(this.getIndex()));
        return map;
    }

    @Override
    public int getRunLimit() {
        return this.myRunLimit.get(this.myRunStart.get(this.getIndex())) + 1;
    }

    @Override
    public int getRunLimit(AttributedCharacterIterator.Attribute att) {
        if (att != TextAttribute.FONT && att != TextAttribute.FOREGROUND) {
            return this.getEndIndex();
        }
        return this.getRunLimit();
    }

    @Override
    public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
        if (attributes.contains(TextAttribute.FONT) || attributes.contains(TextAttribute.FOREGROUND)) {
            return this.getRunLimit();
        }
        return this.getEndIndex();
    }

    @Override
    public int getRunStart() {
        return this.myRunStart.get(this.getIndex());
    }

    @Override
    public int getRunStart(AttributedCharacterIterator.Attribute att) {
        if (att != TextAttribute.FONT && att != TextAttribute.FOREGROUND) {
            return 0;
        }
        return this.getRunStart();
    }

    @Override
    public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
        if (attributes.contains(TextAttribute.FONT) || attributes.contains(TextAttribute.FOREGROUND)) {
            return this.getRunStart();
        }
        return 0;
    }
}

