/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.print.core.comp;

import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;
import javax.swing.JPanel;
import oracle.ide.print.api.PrintPage;

final class Panel
extends JPanel {
    private int myWidth;
    private int myHeight;
    private List<PrintPage> myPages;

    Panel(List<PrintPage> pages) {
        this.myPages = pages;
        this.myHeight = 0;
        this.myWidth = 0;
        for (PrintPage page : this.myPages) {
            Dimension size = page.getSize();
            this.myWidth += size.width;
            this.myHeight = Math.max(this.myHeight, size.height);
        }
    }

    @Override
    public void print(Graphics g) {
        for (PrintPage page : this.myPages) {
            page.print(g);
            g.translate(page.getSize().width, 0);
        }
    }

    @Override
    public int getWidth() {
        return this.myWidth;
    }

    @Override
    public int getHeight() {
        return this.myHeight;
    }
}

