/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideri.importexport;

import oracle.ide.Context;
import oracle.ide.help.CallbackWizardHandler;
import oracle.ideri.importexport.ExportWizard;
import oracle.ideri.importexport.ImportWizard;

public class HelpCallbackWizardHandler
implements CallbackWizardHandler {
    public boolean invokeCallbackWizard(Object wizardInstance, Context context, String[] params) {
        boolean retval = false;
        try {
            if (wizardInstance instanceof ExportWizard) {
                retval = true;
                ExportWizard expWiz = (ExportWizard)wizardInstance;
                if (expWiz.isAvailableAsExportWizard(context)) {
                    expWiz.invokeExportWizard(context, params);
                }
            } else if (wizardInstance instanceof ImportWizard) {
                retval = true;
                ImportWizard impWiz = (ImportWizard)wizardInstance;
                if (impWiz.isAvailableAsImportWizard(context)) {
                    impWiz.invokeImportWizard(context, params);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }

    public Boolean checkCallbackWizard(Object wizardInstance, Context context) {
        Boolean retval = null;
        try {
            if (wizardInstance instanceof ExportWizard) {
                ExportWizard expWiz = (ExportWizard)wizardInstance;
                boolean isAvailable = expWiz.isAvailableAsExportWizard(context);
                retval = isAvailable;
            } else if (wizardInstance instanceof ImportWizard) {
                ImportWizard impWiz = (ImportWizard)wizardInstance;
                boolean isAvailable = impWiz.isAvailableAsImportWizard(context);
                retval = isAvailable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retval;
    }
}

