/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.controls.SelectListPanel;
import oracle.dbtools.raptor.controls.UIDBAccessSafe;
import oracle.dbtools.raptor.dialogs.SQLErrorDialog;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DisconnectVetoException;
import oracle.ide.Ide;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.OptionSelectionDialog;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.db.DatabaseConnections;

public class RaptorDbDisconnectListener
implements ConnectionDisconnectListener {
    public static final String OPTION_COMMIT = ConnectionArb.getString((String)"RDEP_COMMIT");
    public static final String OPTION_ROLLBACK = ConnectionArb.getString((String)"RDEP_ROLLBACK");
    public static final String OPTION_CANCEL_DISCONNECT = ConnectionArb.getString((String)"OPTION_CANCEL_DISCONNECT");
    public static final String[] OPTIONS = new String[]{OPTION_COMMIT, OPTION_ROLLBACK, OPTION_CANCEL_DISCONNECT};
    private static RaptorDbDisconnectListener INSTANCE;

    public static synchronized RaptorDbDisconnectListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RaptorDbDisconnectListener();
        }
        return INSTANCE;
    }

    private RaptorDbDisconnectListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @UIDBAccessSafe
    public void checkDisconnect(ConnectionDetails connectionDetails) throws DisconnectVetoException {
        boolean bl;
        block18: {
            SelectListPanel selectListPanel;
            CheckBoxListModel checkBoxListModel;
            String string = connectionDetails.getQualifiedConnectionName();
            Connection connection = null;
            Connections connections = Connections.getInstance();
            if (!RaptorExtensionConstants.isStandAlone()) return;
            Connection connection2 = connectionDetails.getConnection();
            if (connection2 == null) return;
            if (!connections.lock(connection2, true)) {
                throw new DisconnectVetoException(connectionDetails, "Could not lock connection");
            }
            connection = connection2;
            try {
                if (connection2.isClosed()) {
                    if (connection == null) return;
                    connections.unlock(connection);
                    return;
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "An attempt to determine pending transaction for the just closed connection failed.");
                if (connection == null) return;
                connections.unlock(connection);
                return;
            }
            if (!Connections.isUnsharedWorksheetConnection(string) && (checkBoxListModel = this.determineDependentConnections(string)).getSize() > 0) {
                selectListPanel = new SelectListPanel();
                selectListPanel.setCheckedList(true);
                selectListPanel.setListModel(checkBoxListModel);
                selectListPanel.setHelpID(null);
                selectListPanel.setPrompt(ConnectionArb.getString((String)"RELATED_CONNS_LIST"));
                selectListPanel.setDescription(ConnectionArb.format((String)"RELATED_CONNS_TEXT", (Object[])new Object[]{Connections.getDisplayName(string)}));
                if (!selectListPanel.showDialog(null, ConnectionArb.getString((String)"RELATED_CONNS_TITLE"))) {
                    throw new DisconnectVetoException(connectionDetails, null);
                }
                List list = checkBoxListModel.getSelectionList();
                if (list != null) {
                    for (String string2 : list) {
                        if (connections.closeConnection(string2)) continue;
                        throw new DisconnectVetoException(connectionDetails, null);
                    }
                }
            }
            if (!connections.isOracle(connection2)) return;
            if (!DBUtil.isOracleConnectionAlive((Connection)connection2)) return;
            if (!DBUtil.hasTransaction((Connection)connection2)) return;
            bl = false;
            selectListPanel = new OptionSelectionDialog();
            HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)selectListPanel), "f1_connection_has_pending_changes_html");
            boolean bl2 = selectListPanel.showDialog((Component)Ide.getMainWindow(), ConnectionArb.format((String)"CONNECTION_HAS_TRANSACTIONS_MSG", (Object[])new Object[]{Connections.getDisplayName(string)}), ConnectionArb.getString((String)"SELECT_ON_DISCONNECT_OPTIONS_MSG"), OPTIONS, "f1_connection_has_pending_changes_html");
            if (bl2) {
                String string3 = selectListPanel.getSelectedOption().toString();
                try {
                    if (string3.equals(OPTION_COMMIT)) {
                        connection2.commit();
                        bl = true;
                        break block18;
                    }
                    if (string3.equals(OPTION_ROLLBACK)) {
                        connection2.rollback();
                        bl = true;
                    }
                }
                catch (SQLException sQLException) {
                    SQLErrorDialog.showErrorDialog((String)string, null, (String)"Transaction Error", (SQLException)sQLException);
                }
            }
        }
        if (bl) return;
        throw new DisconnectVetoException(connectionDetails, null);
    }

    private CheckBoxListModel determineDependentConnections(String string) {
        CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
        Connections connections = Connections.getInstance();
        DatabaseConnections databaseConnections = connections.getTemporaryConnectionStore();
        String string2 = databaseConnections.getStoreName();
        Icon icon = RaptorImagesArb.getIcon("DB_W_PLUG");
        for (String string3 : connections.getConnNames(string2)) {
            Properties properties;
            String string4;
            if (!connections.isConnectionOpenFast(string3) || !string.equals(string4 = (properties = connections.getConnectionInfo(string3)).getProperty("UnsharedWorksheetOriginalConnectionName"))) continue;
            checkBoxListModel.addElement((Object)string3, icon, true, false, Connections.getDisplayName(string3));
        }
        return checkBoxListModel;
    }

    @Override
    public void connectionDisconnected(ConnectionDetails connectionDetails) {
    }
}

