/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.panels;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.images.BaseRaptorImages;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.UiResources;

public class ShuttlePanel
extends JPanel
implements ActionListener,
LayoutControl {
    private static final long serialVersionUID = 1L;
    private JScrollPane sourceScrollPane1 = new JScrollPane();
    private JScrollPane selectedScrollPane1 = new JScrollPane();
    private JButton addOne = new JButton();
    private JButton remOne = new JButton();
    private JButton addAll = new JButton();
    private JButton remAll = new JButton();
    private JList _sourceList = new JList(new DefaultListModel());
    private JList _selectedList = new JList(new DefaultListModel());
    private List<String> added;
    private List<String> removed;

    public ShuttlePanel() {
        this._sourceList.setFixedCellWidth(30);
        this._selectedList.setFixedCellWidth(30);
    }

    public ShuttlePanel(List<String> list, List<String> list2) {
        this();
        this.setLists(list, list2);
    }

    public void setLists(List<String> list, List<String> list2) {
        ((DefaultListModel)this._sourceList.getModel()).removeAllElements();
        if (list != null) {
            for (String string : list) {
                ((DefaultListModel)this._sourceList.getModel()).addElement(string);
            }
        }
        ((DefaultListModel)this._selectedList.getModel()).removeAllElements();
        if (list2 != null) {
            for (String string : list2) {
                ((DefaultListModel)this._selectedList.getModel()).addElement(string);
            }
        }
        this.added = new ArrayList<String>();
        this.removed = new ArrayList<String>();
    }

    public void enableShuttle(boolean bl) {
        this.addOne.setEnabled(bl);
        this.remOne.setEnabled(bl);
        this.addAll.setEnabled(bl);
        this.remAll.setEnabled(bl);
        this._selectedList.setEnabled(bl);
        this._sourceList.setEnabled(bl);
    }

    private void selectString(String string) {
        if (this.removed.contains(string)) {
            this.removed.remove(string);
        } else if (!this.added.contains(string)) {
            this.added.add(string);
        }
    }

    private void removeString(String string) {
        if (this.added.contains(string)) {
            this.added.remove(string);
        } else if (!this.removed.contains(string)) {
            this.removed.add(string);
        }
    }

    public List<String> getAdded() {
        return this.added;
    }

    public List<String> getRemoved() {
        return this.removed;
    }

    public List<String> getSelected() {
        ArrayList<String> arrayList = new ArrayList<String>();
        DefaultListModel defaultListModel = (DefaultListModel)this._selectedList.getModel();
        if (defaultListModel != null) {
            for (int i = 0; i < defaultListModel.size(); ++i) {
                String string = (String)defaultListModel.get(i);
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public JPanel getPanel() {
        this._sourceList.setDragEnabled(false);
        this._sourceList.getAccessibleContext().setAccessibleName(ControlsArb.getString("LIST_ACCESS"));
        this._sourceList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = ShuttlePanel.this._sourceList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string = (String)objectArray[i];
                        ((DefaultListModel)ShuttlePanel.this._sourceList.getModel()).removeElement(string);
                        ((DefaultListModel)ShuttlePanel.this._selectedList.getModel()).addElement(string);
                        ShuttlePanel.this.sortList(ShuttlePanel.this._selectedList);
                        ShuttlePanel.this.selectString(string);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this._selectedList.setDragEnabled(false);
        this._selectedList.getAccessibleContext().setAccessibleName(ControlsArb.getString("LIST_ACCESS"));
        this._selectedList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = ShuttlePanel.this._selectedList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string = (String)objectArray[i];
                        ((DefaultListModel)ShuttlePanel.this._selectedList.getModel()).removeElement(string);
                        ((DefaultListModel)ShuttlePanel.this._sourceList.getModel()).addElement(string);
                        ShuttlePanel.this.sortList(ShuttlePanel.this._sourceList);
                        ShuttlePanel.this.removeString(string);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.addAll.setActionCommand(">>");
        this.addAll.getAccessibleContext().setAccessibleName(UiResources.getString("ADD_ALL"));
        this.addAll.setName(UiResources.getString("ADD_ALL"));
        this.addAll.setToolTipText(UiResources.getString("ADD_ALL"));
        this.addAll.setIcon(BaseRaptorImages.getIcon((String)"LAST_ENA"));
        this.addAll.addActionListener(this);
        this.addOne.setActionCommand(">");
        this.addOne.getAccessibleContext().setAccessibleName(UiResources.getString("ADD_SELECTED"));
        this.addOne.setName(UiResources.getString("ADD_SELECTED"));
        this.addOne.setToolTipText(UiResources.getString("ADD_SELECTED"));
        this.addOne.setIcon(BaseRaptorImages.getIcon((String)"NEXT_ENA"));
        this.addOne.addActionListener(this);
        this.remAll.setActionCommand("<<");
        this.remAll.getAccessibleContext().setAccessibleName(UiResources.getString("REMOVE_ALL"));
        this.remAll.setName(UiResources.getString("REMOVE_ALL"));
        this.remAll.setToolTipText(UiResources.getString("REMOVE_ALL"));
        this.remAll.setIcon(BaseRaptorImages.getIcon((String)"FIRST_ENA"));
        this.remAll.addActionListener(this);
        this.remOne.setActionCommand("<");
        this.remOne.getAccessibleContext().setAccessibleName(UiResources.getString("REMOVE_SELECTED"));
        this.remOne.setName(UiResources.getString("REMOVE_SELECTED"));
        this.remOne.setToolTipText(UiResources.getString("REMOVE_SELECTED"));
        this.remOne.setIcon(BaseRaptorImages.getIcon((String)"PREV_ENA"));
        this.remOne.addActionListener(this);
        this.sourceScrollPane1.setViewportView(this._sourceList);
        this.selectedScrollPane1.setViewportView(this._selectedList);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.sourceScrollPane1, LayoutControl.GBC.gbc(0, 0, 1, 6, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        this.add((Component)new JPanel(), LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.Y));
        this.add((Component)this.addOne, LayoutControl.GBC.gbc(1, 1, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.addAll, LayoutControl.GBC.gbc(1, 2, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.remOne, LayoutControl.GBC.gbc(1, 3, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)this.remAll, LayoutControl.GBC.gbc(1, 4, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP));
        this.add((Component)new JPanel(), LayoutControl.GBC.gbc(1, 5, 1, 1, LayoutControl.GBC.Inset.LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.Y));
        this.add((Component)this.selectedScrollPane1, LayoutControl.GBC.gbc(2, 0, 1, 6, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        return this;
    }

    private void sortList(JList jList) {
        int n = jList.getModel().getSize();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)jList.getModel().getElementAt(i);
        }
        Arrays.sort(stringArray, String.CASE_INSENSITIVE_ORDER);
        jList.removeAll();
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (int i = 0; i < n; ++i) {
            defaultListModel.addElement(stringArray[i]);
        }
        jList.setModel(defaultListModel);
        jList.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!actionEvent.getActionCommand().equals(">")) break block4;
                        Object[] objectArray = this._sourceList.getSelectedValues();
                        for (int i = 0; i < objectArray.length; ++i) {
                            String string = (String)objectArray[i];
                            ((DefaultListModel)this._selectedList.getModel()).addElement(string);
                            this.sortList(this._selectedList);
                            ((DefaultListModel)this._sourceList.getModel()).removeElement(string);
                            this.selectString(string);
                        }
                        break block5;
                    }
                    if (!actionEvent.getActionCommand().equals("<")) break block6;
                    Object[] objectArray = this._selectedList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string = (String)objectArray[i];
                        ((DefaultListModel)this._sourceList.getModel()).addElement(string);
                        this.sortList(this._sourceList);
                        ((DefaultListModel)this._selectedList.getModel()).removeElement(string);
                        this.removeString(string);
                    }
                    break block5;
                }
                if (!actionEvent.getActionCommand().equals(">>")) break block7;
                Object[] objectArray = ((DefaultListModel)this._sourceList.getModel()).toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = (String)objectArray[i];
                    ((DefaultListModel)this._selectedList.getModel()).addElement(string);
                    this.sortList(this._selectedList);
                    ((DefaultListModel)this._sourceList.getModel()).removeElement(string);
                    this.selectString(string);
                }
                break block5;
            }
            if (!actionEvent.getActionCommand().equals("<<")) break block5;
            Object[] objectArray = ((DefaultListModel)this._selectedList.getModel()).toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                String string = (String)objectArray[i];
                ((DefaultListModel)this._sourceList.getModel()).addElement(string);
                this.sortList(this._sourceList);
                ((DefaultListModel)this._selectedList.getModel()).removeElement(string);
                this.removeString(string);
            }
        }
    }
}

