/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JToolBar;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.dbtools.raptor.controls.listtable.ListTablePanel;
import oracle.dbtools.raptor.ui.model.StringSearchCategory;
import oracle.dbtools.raptor.ui.panels.Property;
import oracle.javatools.ui.search.SearchCategory;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.util.ModelUtil;

public class PropertiesEditPanel
extends ListTablePanel<Property> {
    static final String EMPTY_STRING = "";
    static final String[] EMPTY_COLUMN_NAMES = new String[]{"", ""};
    private JToolBar _toolbar;
    private SearchField _searchField;

    private PropertiesEditPanel(ListTableModel<Property> listTableModel) {
        super(listTableModel);
    }

    public PropertiesEditPanel() {
        this(EMPTY_COLUMN_NAMES, null);
    }

    public PropertiesEditPanel(String[] stringArray, String[] stringArray2) {
        this(null, stringArray, stringArray2);
    }

    public PropertiesEditPanel(Properties properties, String[] stringArray, String[] stringArray2) {
        this(new PropertyListTableModel(stringArray, stringArray2));
        if (properties != null) {
            this.setProperties(properties);
        }
    }

    public void setProperties(Properties properties) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            arrayList.add(new Property(entry.getKey().toString(), entry.getValue().toString()));
        }
        this.getListTableModel().setRowList(arrayList);
    }

    public Properties getProperties() {
        List list = this.getListTableModel().getRowList();
        Properties properties = new Properties();
        for (Property property : list) {
            properties.put(property.key, property.value);
        }
        return properties;
    }

    @Override
    public void setEditable(boolean bl) {
        if (this.isEditable() != bl) {
            super.setEditable(bl);
            if (bl) {
                this.add((Component)this._toolbar, "First");
            } else {
                this.remove(this._toolbar);
            }
            this.invalidate();
        }
    }

    public void setSorted(boolean bl) {
        ((PropertyListTableModel)this.getListTableModel()).setSorted(bl);
    }

    @Override
    protected void initTablePanel() {
        this._toolbar = new JToolBar();
        this._searchField = new SearchField();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTableScrollPane(), "Center");
        this.add((Component)this._searchField, "Last");
    }

    @Override
    protected void initializeData() {
        super.initializeData();
        this._toolbar.add(Box.createHorizontalGlue());
        AbstractAction abstractAction = this.getListTableModel().getAddAfterSelectedAction();
        JButton jButton = this._toolbar.add(abstractAction);
        jButton.setName("ListTable.Add");
        this._actions.add(abstractAction);
        abstractAction = this.getListTableModel().getRemoveSelectedAction();
        jButton = this._toolbar.add(abstractAction);
        jButton.setName("ListTable.Remove");
        this._actions.add(abstractAction);
        this._searchField.addSearchListener((SearchListener)this.getListTableModel());
        for (StringSearchCategory stringSearchCategory : StringSearchCategory.getCategories()) {
            this._searchField.addCategory((SearchCategory)stringSearchCategory);
        }
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        jDialog.setLayout(new BorderLayout());
        String string = "Key";
        String string2 = "Value";
        PropertiesEditPanel propertiesEditPanel = new PropertiesEditPanel();
        propertiesEditPanel.setSorted(true);
        propertiesEditPanel.setEditable(true);
        Properties properties = new Properties();
        for (int i = 1; i < 101; ++i) {
            properties.put(string + i, string2 + i);
        }
        propertiesEditPanel.setProperties(properties);
        jDialog.add((Component)propertiesEditPanel, "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    static class PropertyListTableModel
    extends ListTableModel<Property>
    implements SearchListener {
        private List<Property> _fullList;
        private String _match;
        private StringSearchCategory _category;
        private boolean _sorted;

        public PropertyListTableModel(String[] stringArray, String[] stringArray2) {
            super(stringArray, stringArray2);
        }

        @Override
        protected Object getValueAt(Property property, int n) {
            return 0 == n ? property.key : property.value;
        }

        @Override
        protected void setValueAt(Object object, Property property, int n) {
            if (0 == n) {
                property.key = (String)object;
            } else {
                property.value = (String)object;
            }
            this.sort();
        }

        @Override
        protected boolean isCellEditable(Property property, int n) {
            return this.isEditable();
        }

        @Override
        protected List<Property> add() {
            Property property = new Property(PropertiesEditPanel.EMPTY_STRING, PropertiesEditPanel.EMPTY_STRING);
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(property);
            this._fullList.add(property);
            return arrayList;
        }

        @Override
        protected void removeSelected() {
            ListTableModel.IndexRange indexRange = this.getRowSelection();
            if (0 < indexRange.size()) {
                for (int i = indexRange.size(); i > 0; --i) {
                    Property property = (Property)this._rowList.remove(indexRange.min());
                    this._fullList.remove(property);
                }
                this.fireTableDataChanged();
            }
        }

        @Override
        public void setRowList(List<Property> list) {
            this._fullList = list;
            this.sort();
            super.setRowList(list);
        }

        @Override
        public List<Property> getRowList() {
            return this._fullList;
        }

        public void searchPerformed(SearchEvent searchEvent) {
            String string = this._match;
            if (searchEvent.isFromClear()) {
                this._match = null;
            } else {
                String string2 = searchEvent.getSearchText();
                if (!ModelUtil.hasLength((String)string2)) {
                    string2 = null;
                }
                this._match = string2;
                this._category = (StringSearchCategory)searchEvent.getSearchCategory();
            }
            if (ModelUtil.areDifferent((Object)this._match, (Object)string)) {
                this.updateFilter();
            }
        }

        public void searchCategoryChanged(SearchEvent searchEvent) {
            StringSearchCategory stringSearchCategory = (StringSearchCategory)searchEvent.getSearchCategory();
            if (stringSearchCategory != this._category) {
                this._category = stringSearchCategory;
                if (this._match != null) {
                    this.updateFilter();
                }
            }
        }

        private void updateFilter() {
            this._rowList.clear();
            this.sort();
            if (this._match == null || this._category == null) {
                this._rowList.addAll(this._fullList);
            } else {
                for (Property property : this._fullList) {
                    if (!this._category.match(this._match, property.key) && (property.value == null || !this._category.match(this._match, property.value.toString()))) continue;
                    this._rowList.add(property);
                }
            }
            this.fireTableDataChanged();
        }

        private void sort() {
            if (this._sorted && this._fullList != null) {
                Collections.sort(this._fullList);
            }
        }

        public void setSorted(boolean bl) {
            if (bl != this._sorted) {
                this._sorted = bl;
                this.sort();
            }
        }
    }
}

