/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderPanel;

public class TableActionControlPanel
extends JPanel
implements LayoutControl {
    private static final long serialVersionUID = 1L;
    public static final int ADD_BUTTON = 1;
    public static final int DELETE_BUTTON = 2;
    public static final int FIRST_BUTTON = 4;
    public static final int PREVIOUS_BUTTON = 8;
    public static final int NEXT_BUTTON = 16;
    public static final int LAST_BUTTON = 32;
    public static final int ADD_DELETE_BUTTONS = 3;
    public static final int SHUTTLE_BUTTONS = 60;
    public static final int ALL_BUTTONS = 63;
    private JScrollPane scrollPane = new JScrollPane();
    private JTable table;
    private TableModel tableModel;
    private TableActionControlPanelController controller;
    private JButton addButton = new JButton();
    private JButton removeButton = new JButton();
    private JButton firstButton = new JButton();
    private JButton prevButton = new JButton();
    private JButton nextButton = new JButton();
    private JButton lastButton = new JButton();
    private JPanel tablePanel = LayoutControl.GBC.createPanel();
    private JPanel buttonPanel = LayoutControl.GBC.createPanel();
    private LayoutManager layout = new BorderLayout();
    private TableListSelectionListener tableListSelectionListener = new TableListSelectionListener();
    private int buttonMask = 0;
    private String title;

    public TableActionControlPanel(TableModel tableModel, TableActionControlPanelController tableActionControlPanelController, final int n) {
        if (n < 0) {
            this.table = new JTable();
            this.scrollPane.setPreferredSize(new Dimension(18, 22));
        } else {
            this.table = new JTable(){
                private static final long serialVersionUID = 1L;

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    return new Dimension((int)this.getPreferredSize().getWidth(), this.getRowHeight() * n);
                }
            };
        }
        this.tableModel = tableModel;
        this.controller = tableActionControlPanelController;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public TableActionControlPanel(TableModel tableModel, TableActionControlPanelController tableActionControlPanelController) {
        this(tableModel, tableActionControlPanelController, -1);
    }

    private void jbInit() throws Exception {
        this.addButton.setName("addButton");
        this.removeButton.setName("removeButton");
        this.firstButton.setName("firstButton");
        this.prevButton.setName("prevButton");
        this.nextButton.setName("nextButton");
        this.lastButton.setName("lastButton");
        this.table.setName("table");
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.scrollPane.setName("scrollPane");
        this.addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableActionControlPanel.this.addButton_actionPerformed(actionEvent);
            }
        });
        this.removeButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.removeButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableActionControlPanel.this.removeButton_actionPerformed(actionEvent);
            }
        });
        this.firstButton.setIcon(OracleIcons.getIcon((String)"first.png"));
        this.firstButton.setMargin(new Insets(0, 0, 0, 0));
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableActionControlPanel.this.firstButton_actionPerformed(actionEvent);
            }
        });
        this.prevButton.setIcon(OracleIcons.getIcon((String)"previous.png"));
        this.prevButton.setMargin(new Insets(0, 0, 0, 0));
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableActionControlPanel.this.prevButton_actionPerformed(actionEvent);
            }
        });
        this.nextButton.setIcon(OracleIcons.getIcon((String)"next.png"));
        this.nextButton.setMargin(new Insets(0, 0, 0, 0));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableActionControlPanel.this.nextButton_actionPerformed(actionEvent);
            }
        });
        this.lastButton.setIcon(OracleIcons.getIcon((String)"last.png"));
        this.lastButton.setMargin(new Insets(0, 0, 0, 0));
        this.lastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableActionControlPanel.this.lastButton_actionPerformed(actionEvent);
            }
        });
        this.table.getSelectionModel().addListSelectionListener(this.tableListSelectionListener);
        this.table.setModel(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.updateLayout();
        this.setButtonStates();
    }

    private void updateLayout() {
        this.removeAll();
        JPanel jPanel = null;
        this.tablePanel.removeAll();
        this.tablePanel.add((Component)this.scrollPane, LayoutControl.GBC.gbc(0, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, LayoutControl.GBC.Fill.XY, LayoutControl.GBC.Spring.XY));
        if ((0x3F & this.buttonMask) > 0) {
            this.buttonPanel.removeAll();
            int n = 0;
            LayoutControl.GBC.Inset inset = LayoutControl.GBC.Inset.FIRST_LINE_START_COMP;
            if ((3 & this.buttonMask) > 0) {
                this.buttonPanel.add((Component)this.addButton, LayoutControl.GBC.gbc(0, n++, 1, 1, inset));
                inset = LayoutControl.GBC.Inset.LINE_START_COMP;
                this.buttonPanel.add((Component)this.removeButton, LayoutControl.GBC.gbc(0, n++, 1, 1, inset));
            }
            LayoutControl.GBC.addVSpring(this.buttonPanel, n++);
            if ((0x3C & this.buttonMask) > 0) {
                this.buttonPanel.add((Component)this.firstButton, LayoutControl.GBC.gbc(0, n++, 1, 1, inset));
                inset = LayoutControl.GBC.Inset.LINE_START_COMP;
                this.buttonPanel.add((Component)this.prevButton, LayoutControl.GBC.gbc(0, n++, 1, 1, inset));
                this.buttonPanel.add((Component)this.nextButton, LayoutControl.GBC.gbc(0, n++, 1, 1, inset));
                this.buttonPanel.add((Component)this.lastButton, LayoutControl.GBC.gbc(0, n++, 1, 1, inset));
                LayoutControl.GBC.addVSpring(this.buttonPanel, n++);
            }
            this.tablePanel.add((Component)this.buttonPanel, LayoutControl.GBC.gbc(1, 0, 1, 1, LayoutControl.GBC.Inset.FIRST_LINE_CONTROL2BUTTON_COMP, LayoutControl.GBC.Fill.Y));
        }
        if (this.title != null) {
            HeaderPanel headerPanel = new HeaderPanel();
            headerPanel.getHeader().setLevel(Header.Level.DIALOG);
            headerPanel.getHeader().setText(this.title);
            headerPanel.getHeader().setExpanded(true);
            headerPanel.getHeader().setExpandable(false);
            headerPanel.setHostedComponent((JComponent)this.tablePanel);
            jPanel = headerPanel;
        } else {
            jPanel = this.tablePanel;
        }
        this.setLayout(this.layout);
        this.add((Component)jPanel, "Center");
    }

    public void setButtons(int n) {
        this.buttonMask = n;
        this.addButton.setVisible((n & 1) == 1);
        this.removeButton.setVisible((n & 2) == 2);
        this.firstButton.setVisible((n & 4) == 4);
        this.prevButton.setVisible((n & 8) == 8);
        this.nextButton.setVisible((n & 0x10) == 16);
        this.lastButton.setVisible((n & 0x20) == 32);
        this.updateLayout();
        this.validate();
    }

    public int getButtons() {
        return this.buttonMask;
    }

    private void addButton_actionPerformed(ActionEvent actionEvent) {
        if (this.controller != null) {
            this.controller.addButtonPressed(actionEvent);
        }
    }

    private void removeButton_actionPerformed(ActionEvent actionEvent) {
        if (this.controller != null) {
            this.controller.removeButtonPressed(actionEvent);
        }
    }

    private void firstButton_actionPerformed(ActionEvent actionEvent) {
        if (this.controller != null) {
            this.controller.firstButtonPressed(actionEvent);
        }
    }

    private void prevButton_actionPerformed(ActionEvent actionEvent) {
        if (this.controller != null) {
            this.controller.previousButtonPressed(actionEvent);
        }
    }

    private void nextButton_actionPerformed(ActionEvent actionEvent) {
        if (this.controller != null) {
            this.controller.nextButtonPressed(actionEvent);
        }
    }

    private void lastButton_actionPerformed(ActionEvent actionEvent) {
        if (this.controller != null) {
            this.controller.lastButtonPressed(actionEvent);
        }
    }

    public JTable getTable() {
        return this.table;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.table.setEnabled(bl);
        this.setButtonStates();
    }

    private void setButtonStates() {
        boolean bl = this.isEnabled();
        if (!bl || this.tableModel == null) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.firstButton.setEnabled(false);
            this.prevButton.setEnabled(false);
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        } else {
            int n = this.table.getSelectedRow();
            this.addButton.setEnabled(true);
            if (n >= 0) {
                this.firstButton.setEnabled(n != 0);
                this.prevButton.setEnabled(n != 0);
                this.nextButton.setEnabled(n < this.tableModel.getRowCount() - 1);
                this.lastButton.setEnabled(n < this.tableModel.getRowCount() - 1);
                this.removeButton.setEnabled(true);
            } else {
                this.firstButton.setEnabled(false);
                this.prevButton.setEnabled(false);
                this.nextButton.setEnabled(false);
                this.lastButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            }
        }
        this.setButtons(this.buttonMask);
    }

    public void setTitle(String string) {
        this.title = string;
        this.updateLayout();
    }

    private class TableListSelectionListener
    implements ListSelectionListener {
        private TableListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TableActionControlPanel.this.setButtonStates();
        }
    }

    public static interface TableActionControlPanelController {
        public void addButtonPressed(ActionEvent var1);

        public void removeButtonPressed(ActionEvent var1);

        public void firstButtonPressed(ActionEvent var1);

        public void previousButtonPressed(ActionEvent var1);

        public void nextButtonPressed(ActionEvent var1);

        public void lastButtonPressed(ActionEvent var1);
    }
}

