/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui.controls;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.actions.ActionControl;
import oracle.dbtools.raptor.ui.controls.GroupActionControl;
import oracle.dbtools.raptor.ui.controls.PanelActionControl;

public class PropertyPanelActionControl
extends PanelActionControl
implements LayoutControl {
    private static final int FIRST_ROW = 0;
    private static final int NULL_ROW = -1;
    private List<ActionControl> childControls = new ArrayList<ActionControl>();
    private int firstRow = -1;
    private boolean hasVSpring;

    public PropertyPanelActionControl(String string, String string2, List<ActionControl> list) {
        super(string, string2, new JPanel(new GridBagLayout()));
        if (list != null) {
            this.addChildControls(list);
        }
    }

    public PropertyPanelActionControl(String string, String string2) {
        this(string, string2, (List<ActionControl>)null);
    }

    public PropertyPanelActionControl(List<ActionControl> list) {
        this(null, null, list);
    }

    public PropertyPanelActionControl() {
        this((String)null, (String)null, (List<ActionControl>)null);
    }

    @Override
    public JPanel getUI() {
        JPanel jPanel = super.getUI();
        if (this.firstRow == -1) {
            this.LayoutPropertyPanel(jPanel);
        }
        return jPanel;
    }

    @Override
    public List<ActionControl> getChildControls() {
        return this.childControls;
    }

    public void addChildControls(List<ActionControl> list) {
        this.childControls.addAll(list);
    }

    protected boolean isFirst(int n) {
        return n == 0;
    }

    protected LayoutControl.GBC.Inset getLabelInset(int n) {
        if (this.isFirst(n)) {
            return LayoutControl.GBC.Inset.FIRST_LINE_START_COMP;
        }
        return LayoutControl.GBC.Inset.LINE_START_COMP;
    }

    protected LayoutControl.GBC.Inset adjustLabelInset(LayoutControl.GBC.Inset inset) {
        LayoutControl.GBC.Inset inset2 = inset;
        switch (inset) {
            case FIRST_LINE_START_COMP: {
                inset2 = LayoutControl.GBC.Inset.PROPERTY_PANEL_FIRST_LINE_LABEL;
                break;
            }
            case LINE_START_COMP: {
                inset2 = LayoutControl.GBC.Inset.PROPERTY_PANEL_LINE_LABEL;
                break;
            }
        }
        return inset2;
    }

    protected LayoutControl.GBC.Inset getControlInset(int n) {
        if (this.isFirst(n)) {
            return LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP;
        }
        return LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP;
    }

    public void LayoutPropertyPanel(JPanel jPanel) {
        this.print("LayoutPropertyPanel(panel)..enter;");
        this.hasVSpring = false;
        List<ActionControl> list = this.getPropertyControlList();
        if (list.size() > 0) {
            this.firstRow = 0;
            Iterator<ActionControl> iterator = list.iterator();
            int n = this.firstRow;
            while (iterator.hasNext()) {
                ActionControl actionControl = iterator.next();
                n = this.layoutPropertyControl(jPanel, actionControl, n);
            }
            if (!this.hasVSpring) {
                LayoutControl.GBC.addVSpring(jPanel, n);
            }
        }
        this.print("LayoutPropertyPanel(panel)..exit;");
    }

    protected List<ActionControl> getPropertyControlList(List<ActionControl> list, ActionControl actionControl) {
        List<ActionControl> list2;
        this.print("getPropertyControlList(list<AC>, control)..enter;");
        List<ActionControl> list3 = list;
        if (actionControl.getPrompt() != null || actionControl.getUI() != null) {
            list.add(actionControl);
        }
        List<ActionControl> list4 = list2 = actionControl instanceof GroupActionControl ? actionControl.getChildControls() : null;
        if (list2 != null) {
            for (ActionControl actionControl2 : list2) {
                list3 = this.getPropertyControlList(list3, actionControl2);
            }
        }
        this.print("getPropertyControlList(list<AC>, control)..exit;");
        return list3;
    }

    protected List<ActionControl> getPropertyControlList() {
        this.print("getPropertyControlList()..enter;");
        List<ActionControl> list = new ArrayList<ActionControl>();
        for (ActionControl actionControl : this.childControls) {
            if (actionControl == null) continue;
            list = this.getPropertyControlList(list, actionControl);
        }
        this.print("getPropertyControlList()..enter;");
        return list;
    }

    protected int layoutPropertyControl(JPanel jPanel, ActionControl actionControl, int n) {
        this.print("layoutPropertyControl(panel, AC, row)..enter; row=" + n);
        String string = actionControl.getPrompt();
        Component component = actionControl.getUI();
        LayoutControl.GBC.Fill fill = LayoutControl.GBC.Fill.X;
        if (actionControl.fillVertical()) {
            fill = LayoutControl.GBC.Fill.XY;
        }
        LayoutControl.GBC.Spring spring = LayoutControl.GBC.Spring.X;
        if (actionControl.springVertical()) {
            spring = LayoutControl.GBC.Spring.XY;
            this.hasVSpring = true;
        }
        if (string == null) {
            jPanel.add(component, LayoutControl.GBC.gbc(0, n, 2, 1, this.getLabelInset(n), fill, spring));
            this.print("layoutPropertyControl(panel, AC, row)..panel.add (prompt=null); row=" + n + ", ui=" + component.getName());
        } else {
            JLabel jLabel = new JLabel(string);
            jLabel.setName(actionControl.getName() + "_Label");
            if (component != null) {
                jLabel.setLabelFor(component);
                LayoutControl.GBC.Inset inset = this.getLabelInset(n);
                inset = this.adjustLabelInset(inset);
                jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, n, 1, 1, inset, LayoutControl.GBC.Fill.NONE, LayoutControl.GBC.Spring.NONE, LayoutControl.GBC.Anchor.FIRST_LINE_START));
                jPanel.add(component, LayoutControl.GBC.gbc(1, n, 1, 1, this.getControlInset(n), fill, spring));
                this.print("layoutPropertyControl(panel, AC, row)..panel.add (ui != null); row=" + n + ", label=" + jLabel.getText());
                this.print("layoutPropertyControl(panel, AC, row)..panel.add (ui != null); row=" + n + ", ui=" + component.getName());
            } else {
                jPanel.add((Component)jLabel, LayoutControl.GBC.gbc(0, n, 2, 1, this.getLabelInset(n), fill));
                this.print("layoutPropertyControl(panel, AC, row)..panel.add (ui == null); row=" + n);
            }
        }
        this.print("layoutPropertyControl(panel, AC, row)..exit; row=" + n);
        return ++n;
    }

    private void print(String string) {
    }
}

