/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.view.View;

public abstract class RDockableWindow
extends DockableWindow {
    private ContextMenu m_contextMenu;
    private UIUtils.MousePopupTriggerListener mListener;
    private UIUtils.ToolbarActionsContextMenuListener cmListener;

    public void stateChange(int n) {
        super.stateChange(n);
        switch (n) {
            case 1: {
                if (null != this.mListener) break;
                this.mListener = this.getMousePopupTriggerListener();
                if (this.mListener == null) break;
                assert (this.getGUI() != null);
                this.addMousePopupTriggerListenerRecursive(this.getGUI(), this.mListener);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.getGUI() == null) break;
                this.removeMousePopupTriggerListenerRecursive(this.getGUI(), this.mListener);
                this.mListener = null;
            }
        }
    }

    private void addMousePopupTriggerListenerRecursive(Component component, UIUtils.MousePopupTriggerListener mousePopupTriggerListener) {
        if (null == mousePopupTriggerListener) {
            return;
        }
        MouseListener[] mouseListenerArray = component.getMouseListeners();
        if (mouseListenerArray.length > 0) {
            for (MouseListener object : mouseListenerArray) {
                if (!(object instanceof UIUtils.MousePopupTriggerListener)) continue;
                return;
            }
            component.addMouseListener((MouseListener)mousePopupTriggerListener);
        }
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.addMousePopupTriggerListenerRecursive(component2, mousePopupTriggerListener);
            }
        }
    }

    private void removeMousePopupTriggerListenerRecursive(Component component, UIUtils.MousePopupTriggerListener mousePopupTriggerListener) {
        if (null == mousePopupTriggerListener) {
            return;
        }
        component.removeMouseListener((MouseListener)mousePopupTriggerListener);
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.removeMousePopupTriggerListenerRecursive(component2, mousePopupTriggerListener);
            }
        }
    }

    public ContextMenu getContextMenu() {
        Toolbar toolbar;
        if (null == this.m_contextMenu) {
            this.m_contextMenu = super.getContextMenu();
            if (null == this.m_contextMenu) {
                this.m_contextMenu = new ContextMenu();
            }
            UIUtils.addMnemonicSolver((ContextMenu)this.m_contextMenu);
        }
        if (null == this.cmListener && (toolbar = this.getToolbar()) != null) {
            this.cmListener = new UIUtils.ToolbarActionsContextMenuListener(toolbar);
            this.m_contextMenu.addContextMenuListener((ContextMenuListener)this.cmListener);
        }
        return this.m_contextMenu;
    }

    public final void setContextMenu(ContextMenu contextMenu) {
        if (this.m_contextMenu != null) {
            this.m_contextMenu.removeContextMenuListener((ContextMenuListener)this.cmListener);
            this.cmListener = null;
        }
        this.m_contextMenu = contextMenu;
    }

    protected UIUtils.MousePopupTriggerListener getMousePopupTriggerListener() {
        return new UIUtils.MousePopupTriggerListener(){

            protected void doPopup(MouseEvent mouseEvent) {
                RDockableWindow.this.getContextMenu().show(RDockableWindow.this.getContext(mouseEvent));
            }
        };
    }

    protected RDockableWindow() {
    }

    protected RDockableWindow(IdeMainWindow ideMainWindow, String string) {
        super(ideMainWindow, string);
    }

    protected RDockableWindow(String string) {
        super(string);
    }

    protected RDockableWindow(View view, String string) {
        super(view, string);
    }

    protected RDockableWindow(View view) {
        super(view);
    }
}

