/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import oracle.dbtools.util.Logger;

public interface LayoutControl {

    public static class GBC {
        public static GridBagConstraints DIALOG_MAIN_PANEL = GBC.gbc(0, 0, 1, 1, Inset.DIALOG_MAIN_PANEL, Fill.XY, Spring.XY);
        public static GridBagConstraints TAB_PANEL = GBC.gbc(0, 0, 1, 1, Inset.TAB_PANEL, Fill.XY, Spring.XY);
        public static GridBagConstraints TITLED_SUB_PANEL = GBC.gbc(0, 0, 1, 1, Inset.TITLED_SUB_PANEL, Fill.XY, Spring.XY);
        public static GridBagConstraints SUB_PANEL = GBC.gbc(0, 0, 1, 1, Inset.SUB_PANEL, Fill.XY, Spring.XY);
        public static GridBagConstraints WIZARD_PANEL = GBC.gbc(0, 0, 1, 1, Inset.WIZARD_PANEL, Fill.XY, Spring.XY);

        public static void addSpring(JPanel jPanel, int n, int n2) {
            jPanel.add(Box.createGlue(), GBC.gbc(0, n, n2, 1, Inset.LINE_START_COMP, Fill.XY, Spring.XY));
        }

        public static void addVSpring(JPanel jPanel, int n) {
            jPanel.add(Box.createGlue(), GBC.gbc(0, n, 1, 1, Inset.LINE_START_COMP, Fill.Y, Spring.Y));
        }

        public static void addVSpring20(JPanel jPanel, int n) {
            jPanel.add(Box.createGlue(), GBC.gbc(0, n, 1, 1, Inset.LINE_START_COMP, Fill.Y, Spring.Y20));
        }

        public static void addHSpring(JPanel jPanel, int n) {
            jPanel.add(Box.createGlue(), GBC.gbc(n, 0, 1, 1, Inset.LINE_START_COMP, Fill.X, Spring.X));
        }

        public static GridBagConstraints gbc(int n, int n2, int n3, int n4, Inset inset) {
            return GBC.gbc(n, n2, n3, n4, inset, Fill.NONE);
        }

        public static GridBagConstraints gbc(int n, int n2, int n3, int n4, Inset inset, Fill fill) {
            return GBC.gbc(n, n2, n3, n4, inset, fill, Spring.NONE);
        }

        public static GridBagConstraints gbc(int n, int n2, int n3, int n4, Inset inset, Fill fill, Spring spring) {
            return GBC.gbc(n, n2, n3, n4, inset, fill, spring, Anchor.LINE_START);
        }

        public static GridBagConstraints gbc(int n, int n2, int n3, int n4, Inset inset, Fill fill, Spring spring, Anchor anchor) {
            return new GridBagConstraints(n, n2, n3, n4, spring.x(), spring.y(), anchor.anchor, fill.fill, inset.inset, 0, 0);
        }

        public static JPanel createPanel() {
            return new JPanel(new GridBagLayout());
        }

        public static JPanel createDialogMainPanel(Component component) {
            JPanel jPanel = GBC.createPanel();
            jPanel.add(component, DIALOG_MAIN_PANEL);
            return jPanel;
        }

        public static JPanel createSubPanel(Component component) {
            JPanel jPanel = GBC.createPanel();
            jPanel.add(component, SUB_PANEL);
            return jPanel;
        }

        public static JPanel createTabPanel(Component component) {
            JPanel jPanel = GBC.createPanel();
            jPanel.add(component, TAB_PANEL);
            return jPanel;
        }

        public static JPanel createTitledSubPanel(String string, Component component) {
            JPanel jPanel = GBC.createPanel();
            if (string != null && !string.isEmpty()) {
                jPanel.setBorder(BorderFactory.createTitledBorder(string));
                jPanel.getAccessibleContext().setAccessibleName(string);
            }
            jPanel.add(component, TITLED_SUB_PANEL);
            return jPanel;
        }

        public static JPanel createWizardPanel(Component component) {
            JPanel jPanel = GBC.createPanel();
            jPanel.add(component, WIZARD_PANEL);
            return jPanel;
        }

        public static void outlineBorders(Component component) {
            GBC.outlineBorders(component, Color.red, null, true);
        }

        public static void outlineBorders(Component component, Color color, String string, boolean bl) {
            if (component instanceof JComponent) {
                Border border;
                Component[] componentArray = (Component[])component;
                Border border2 = BorderFactory.createLineBorder(color != null ? color : Color.red);
                if (null == string) {
                    string = componentArray.getName();
                    String string2 = string = string != null ? string : componentArray.getClass().getSimpleName();
                }
                if (string != null) {
                    border2 = BorderFactory.createTitledBorder(border2, string);
                }
                if ((border = componentArray.getBorder()) != null) {
                    border2 = new CompoundBorder(border2, border);
                }
                try {
                    componentArray.setBorder(border2);
                }
                catch (Exception exception) {
                    Logger.warn(GBC.class, (Throwable)exception);
                }
            }
            if (bl && component instanceof Container) {
                for (Component component2 : ((Container)component).getComponents()) {
                    GBC.outlineBorders(component2, color, null, bl);
                }
            }
        }

        public static enum Spring {
            NONE(0.0, 0.0),
            X(1.0, 0.0),
            Y(0.0, 1.0),
            Y20(0.0, 0.2),
            XY(1.0, 1.0);

            private double x;
            private double y;

            private Spring(double d, double d2) {
                this.x = d;
                this.y = d2;
            }

            public double x() {
                return this.x;
            }

            public double y() {
                return this.y;
            }
        }

        public static enum Inset {
            NONE(new Insets(0, 0, 0, 0)),
            FIRST_LINE_START(new Insets(16, 10, 0, 0)),
            FIRST_LINE_START_SUB(new Insets(0, 8, 0, 0)),
            PAGE_START_FULL(new Insets(16, 10, 0, 10)),
            PAGE_START_FULL_SUB(new Insets(0, 8, 0, 8)),
            PAGE_START_LABEL2CONTROL(new Insets(16, 8, 0, 0)),
            FIRST_LINE_END_CONTROL2BUTTON(new Insets(16, 8, 0, 10)),
            FIRST_LINE_END_CONTROL2BUTTON_SUB(new Insets(0, 8, 0, 0)),
            FIRST_LINE_END_LABEL2CONTROL(new Insets(16, 8, 0, 10)),
            FIRST_LINE_END_LABEL2CONTROL_SUB(new Insets(0, 8, 0, 0)),
            LINE_START(new Insets(6, 10, 0, 0)),
            LINE_START_TAB(new Insets(6, 8, 0, 0)),
            LINE_FULL(new Insets(6, 10, 0, 10)),
            LINE_FULL_SUB(new Insets(6, 8, 0, 8)),
            CENTER_FULL(new Insets(16, 10, 10, 10)),
            LINE_END_LABEL2CONTROL(new Insets(6, 8, 0, 10)),
            LINE_END_LABEL2CONTROL_TAB(new Insets(6, 8, 0, 8)),
            PAGE_END_FULL(new Insets(6, 10, 10, 10)),
            PAGE_END_FULL_SUB(new Insets(6, 8, 0, 8)),
            LAST_LINE_START(new Insets(6, 10, 10, 0)),
            DIALOG_MAIN_PANEL(new Insets(16, 10, 10, 10)),
            TAB_PANEL(new Insets(8, 8, 8, 8)),
            SUB_PANEL(new Insets(8, 8, 8, 8)),
            TITLED_SUB_PANEL(new Insets(2, 6, 6, 6)),
            WIZARD_PANEL(new Insets(8, 8, 8, 8)),
            FIRST_LINE_START_COMP(new Insets(0, 0, 0, 0)),
            FIRST_LINE_CONTROL2BUTTON_COMP(new Insets(0, 8, 0, 0)),
            FIRST_LINE_LABEL2CONTROL_COMP(new Insets(0, 8, 0, 0)),
            FIRST_LINE_CONTROL2CONTROL_COMP(new Insets(0, 24, 0, 0)),
            LINE_START_COMP(new Insets(6, 0, 0, 0)),
            LINE_CONTROL2BUTTON_COMP(new Insets(6, 8, 0, 0)),
            LINE_LABEL2CONTROL_COMP(new Insets(6, 8, 0, 0)),
            LINE_CONTROL2CONTROL_COMP(new Insets(6, 24, 0, 0)),
            SECTION_LINE_START_COMP(new Insets(16, 0, 0, 0)),
            SECTION_LINE_CONTROL2BUTTON_COMP(new Insets(16, 8, 0, 0)),
            SECTION_LINE_LABEL2CONTROL_COMP(new Insets(16, 8, 0, 0)),
            SECTION_LINE_CONTROL2CONTROL_COMP(new Insets(16, 24, 0, 0)),
            PROPERTY_PANEL_FIRST_LINE_LABEL(new Insets(2, 0, 0, 0)),
            PROPERTY_PANEL_LINE_LABEL(new Insets(8, 0, 0, 0));

            private final Insets inset;

            private Inset(Insets insets) {
                this.inset = insets;
            }

            public Insets inset() {
                return this.inset;
            }
        }

        public static enum Anchor {
            FIRST_LINE_START(23),
            PAGE_START(19),
            FIRST_LINE_END(24),
            LINE_START(21),
            CENTER(10),
            LINE_END(22),
            LAST_LINE_START(25),
            PAGE_END(20),
            LAST_LINE_END(26);

            private final int anchor;

            private Anchor(int n2) {
                this.anchor = n2;
            }

            public int anchor() {
                return this.anchor;
            }
        }

        public static enum Fill {
            NONE(0),
            X(2),
            Y(3),
            XY(1);

            private final int fill;

            private Fill(int n2) {
                this.fill = n2;
            }

            public int fill() {
                return this.fill;
            }
        }
    }

    public static class LC {
        public static final int MARGIN = 10;
        public static final int LABEL_CONTROL_HGAP = 8;
        public static final int HORIZONTAL_INDENT = 16;
        public static final int BUTTON_HGAP = 8;
        public static final int RADIO_OPTION_HGAP = 16;
        public static final int MAJOR_SECTION_VGAP = 16;
        public static final int CONTROL_VGAP = 6;
        public static final int HEADER_INSTRUCTION_VGAP = 6;
        public static final int INSTRUCTION_CONTROL_VGAP = 8;
        public static final int TOP_MARGIN = 16;
        public static final int CONTROL_HGAP = 24;
        public static final int ICONIC_BUTTON_HGAP = 6;
        public static final int TAB_TOP_MARGIN = 10;
        public static final int TAB_MARGIN = 8;
        public static final int HEADER_CONTROL_VGAP = 8;
        public static final int GROUP_BOX_MARGIN = 8;
        public static final int HEADER_CONTROL_INDENT = 8;
        public static final int NO_HGAP = 0;
        public static final int NO_VGAP = 0;
    }
}

