/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.status;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.db.DBException;

public class StatusNode
extends Node {
    private static final String PATH_ROOT = "StatusNode";
    private static final URL PATH_ROOT_URL = URLFactory.newDirURL((String)"sqldev.status", (String)"StatusNode");
    String mDisplayName;
    String mConnName;

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    static URL createURL(String string) {
        String string2 = Connections.getStoreName(string);
        String string3 = Connections.getConnectionName(string);
        URL uRL = URLFactory.newDirURL((URL)PATH_ROOT_URL, (String)StatusNode.encode(string2));
        return URLFactory.newURL((URL)uRL, (String)string3);
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this.mDisplayName = StatusNode.decode(URLFileSystem.getFileName((URL)uRL));
        String string = StatusNode.decode(URLFileSystem.getFileName((URL)URLFileSystem.getParent((URL)uRL)));
        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey(string, this.mDisplayName);
        this.mConnName = connectionKey.getQualifiedName();
    }

    public Connection getConnection() {
        try {
            return Connections.getInstance().getConnection(this.mConnName, false);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    public String getLongLabel() {
        return this.mDisplayName;
    }

    public String getShortLabel() {
        return this.mDisplayName;
    }

    public String getConnName() {
        return this.mConnName;
    }

    protected void openImpl() throws IOException {
        super.openImpl();
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
    }
}

