/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.service.impl;

import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;

public abstract class AbstractService {
    private String privateConnectionName;
    private String privateDbURL;

    protected void runTask(final String string, final String string2, final BiConsumer<Connection, String> biConsumer) {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(CommonArb.getString("SERVICE_CONNECTING"), false, IRaptorTaskRunMode.MODAL_OPTIONAL){

            protected Void doWork() throws TaskException {
                String string3;
                Connection connection = AbstractService.this.getConnection(string, string2);
                String string22 = string3 = AbstractService.this.privateConnectionName != null ? AbstractService.this.privateConnectionName : string;
                if (connection != null) {
                    try {
                        biConsumer.accept(connection, string3);
                    }
                    catch (RuntimeException runtimeException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "unable to perform action", runtimeException);
                    }
                } else {
                    SwingUtilities.invokeLater(() -> MessageDialog.error((Component)Ide.getMainWindow(), (Object)CommonArb.getString("SERVICE_UNABLE_TO_CONNECT"), (String)CommonArb.getString("SERVICE_ERROR"), null));
                }
                return null;
            }
        };
        raptorTask.setCancellable(false);
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getUserName(Connection connection) {
        String string = null;
        if (Connections.getInstance().lock(connection)) {
            try {
                try (PreparedStatement preparedStatement = connection.prepareStatement("SELECT USER FROM DUAL");){
                    ResultSet resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    string = resultSet.getString("USER");
                }
                catch (SQLException sQLException) {
                    string = null;
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return string;
    }

    private Connection getConnection(String string, String string2) {
        Connection connection = null;
        try {
            Object object;
            if (string2 == null) {
                this.privateConnectionName = null;
                this.privateDbURL = null;
            } else if (this.privateDbURL == null || !string2.equals(this.privateDbURL)) {
                this.privateConnectionName = this.createNewPrivateConnectionName(string, string2);
                object = new ServiceConnectionListener(string, this.privateConnectionName);
                ((ServiceConnectionListener)object).attach();
                this.privateDbURL = string2;
            }
            object = this.privateConnectionName != null ? this.privateConnectionName : string;
            connection = Connections.getInstance().getConnection((String)object);
        }
        catch (RuntimeException | DBException | ConnectionException throwable) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "unable to obtain connection '" + string + "'", throwable);
        }
        return connection;
    }

    private String createNewPrivateConnectionName(String string, String string2) throws ConnectionException {
        String string3;
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)Connections.getInstance().getConnectionInfo(string));
        if (string2 != null) {
            string3 = properties.getProperty("customUrl");
            int n = string3.indexOf(64);
            String string4 = n > 0 ? string3.substring(0, n + 1) : "jdbc:oracle:thin:@";
            properties.put("customUrl", string4 + string2);
            properties.remove("hostname");
            properties.remove("sid");
            properties.remove("serviceName");
        }
        string3 = Connections.getInstance().createPrivateConnection(string, properties);
        return string3;
    }

    private static class ServiceConnectionListener
    implements ConnectionListener {
        private String originalConnectionName;
        private String privateConnectionName;
        private static final Set<ServiceConnectionListener> listeners = new HashSet<ServiceConnectionListener>();

        ServiceConnectionListener(String string, String string2) {
            this.originalConnectionName = string;
            this.privateConnectionName = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attach() {
            Set<ServiceConnectionListener> set = listeners;
            synchronized (set) {
                listeners.add(this);
                Connections.getInstance().addConnectionListener(this);
            }
        }

        @Override
        public void connectionAdded(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRemoved(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionRenamed(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionModified(ConnectionEvent connectionEvent) {
        }

        @Override
        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionClosed(ConnectionEvent connectionEvent) {
            Set<ServiceConnectionListener> set = listeners;
            synchronized (set) {
                if (connectionEvent.getConnectionName().equals(this.originalConnectionName)) {
                    try {
                        Connections.getInstance().removePrivateConnection(this.privateConnectionName);
                    }
                    catch (RuntimeException | ConnectionException throwable) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unable to remove private connection name: " + this.privateConnectionName, throwable);
                    }
                    Connections.getInstance().removeConnectionListener(this);
                    listeners.remove(this);
                    this.privateConnectionName = null;
                    this.originalConnectionName = null;
                }
            }
        }
    }
}

