/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.awt.Component;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.runner.GridData;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.ide.Ide;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.jdeveloper.compiler.IdeLog;

public class StructuredLogPage
extends AbstractLogPage {
    private ArrayList<GridData> structuredOutputData = new ArrayList();
    private static StructuredLogPage instance = null;
    private JSplitPane splitPane;
    private JTable parentTbl;
    private JTable childTbl;
    private TableModel[] models;
    private int lastPos = -1;

    public static StructuredLogPage getInstance() {
        if (instance == null) {
            instance = new StructuredLogPage();
            IdeLog ideLog = new IdeLog();
            ideLog.registerAsynchronousLogPage((LogPage)instance);
            ideLog.setProject(Ide.getActiveProject() != null ? Ide.getActiveProject() : Ide.getDefaultProject());
            ideLog.setWorkspace(Ide.getActiveWorkspace() != null ? Ide.getActiveWorkspace() : Ide.getDefaultWorkspace());
        }
        return instance;
    }

    void resetContent(ParamTableModel paramTableModel, CallableStatement callableStatement) {
        this.structuredOutputData = new ArrayList();
        int n = 0;
        if (paramTableModel == null) {
            return;
        }
        for (int i = 0; i < paramTableModel.getRowCount(); ++i) {
            GridData gridData = new GridData();
            if (!paramTableModel.getParameter(i).isOutputBound()) continue;
            try {
                gridData = paramTableModel.getParameter(i).getType().extractValue(callableStatement, ++n);
            }
            catch (SQLException sQLException) {
                gridData = new GridData();
                gridData.header = new String[1];
                gridData.header[0] = "";
                gridData.data = new ArrayList<Object[]>();
                Object[] objectArray = new Object[1];
                gridData.data.add(objectArray);
                objectArray[0] = "<html><font color=red>" + sQLException.getMessage() + "</font></html>";
            }
            gridData.name = paramTableModel.getParameter(i).getParamName();
            this.structuredOutputData.add(gridData);
        }
        this.syncModels();
        if (this.parentTbl != null) {
            this.parentTbl.invalidate();
        }
        if (this.childTbl != null) {
            if (this.models.length > 0) {
                this.childTbl.setModel(this.models[0]);
            }
            this.childTbl.invalidate();
        }
    }

    public StructuredLogPage() {
        super("StructuredLogPageId", RunnerArb.getString("OUTPUT_VARIABLES"), RaptorImagesArb.getIcon("RUNTABLE"), true);
    }

    public Component getGUI() {
        if (this.splitPane == null) {
            this.parentTbl = new JTable();
            this.parentTbl.setModel(new AbstractTableModel(){

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public String getColumnName(int n) {
                    return RunnerArb.getString("COLUMN_VARIABLE");
                }

                @Override
                public int getRowCount() {
                    return StructuredLogPage.this.structuredOutputData == null ? 0 : StructuredLogPage.this.structuredOutputData.size();
                }

                @Override
                public Object getValueAt(int n, int n2) {
                    return StructuredLogPage.this.structuredOutputData.size() == 0 ? "N/A" : ((GridData)((StructuredLogPage)StructuredLogPage.this).structuredOutputData.get((int)n)).name;
                }
            });
            ColumnAutoSizer.autoResizeTable((JTable)this.parentTbl, (String)ColumnAutoSizer.AUTO_FIT_OPTIMUM);
            this.parentTbl.setSelectionMode(0);
            ListSelectionModel listSelectionModel = this.parentTbl.getSelectionModel();
            listSelectionModel.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                    if (listSelectionModel.isSelectionEmpty()) {
                        return;
                    }
                    int n = listSelectionModel.getMinSelectionIndex();
                    StructuredLogPage.this.updateActiveTab(n);
                }
            });
            this.childTbl = new JTable();
            ColumnAutoSizer.autoResizeTable((JTable)this.childTbl, (String)ColumnAutoSizer.AUTO_FIT_OPTIMUM);
            this.syncModels();
            JScrollPane jScrollPane = new JScrollPane(this.parentTbl);
            this.parentTbl.setFillsViewportHeight(true);
            final JTabbedPane jTabbedPane = new JTabbedPane();
            jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    StructuredLogPage.this.updateActiveTab(jTabbedPane.getSelectedIndex());
                }
            });
            JScrollPane jScrollPane2 = new JScrollPane(this.childTbl);
            this.childTbl.setFillsViewportHeight(true);
            jTabbedPane.add(RunnerArb.getString("VARIABLE_VALUE"), jScrollPane2);
            this.splitPane = new JSplitPane(1, jScrollPane, jTabbedPane);
            this.splitPane.setDividerLocation(150);
            RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    int n = StructuredLogPage.this.parentTbl.getModel().getRowCount() - 1;
                    if (n != -1) {
                        StructuredLogPage.this.parentTbl.setRowSelectionInterval(n, n);
                        StructuredLogPage.this.parentTbl.setColumnSelectionInterval(1, 1);
                    }
                }
            };
            ArrayList<4> arrayList = new ArrayList<4>();
            arrayList.add(raptorTaskAdapter);
        }
        return this.splitPane;
    }

    private void syncModels() {
        this.models = new AbstractTableModel[this.structuredOutputData.size()];
        int n = 0;
        while (n < this.structuredOutputData.size()) {
            try {
                final int n2 = n++;
                this.models[n2] = new AbstractTableModel(){

                    @Override
                    public int getColumnCount() {
                        return StructuredLogPage.this.structuredOutputData.size() == 0 ? 1 : ((GridData)((StructuredLogPage)StructuredLogPage.this).structuredOutputData.get((int)n2)).header.length;
                    }

                    @Override
                    public String getColumnName(int n) {
                        return StructuredLogPage.this.structuredOutputData.size() == 0 ? "N/A" : ((GridData)((StructuredLogPage)StructuredLogPage.this).structuredOutputData.get((int)n2)).header[n];
                    }

                    @Override
                    public int getRowCount() {
                        return StructuredLogPage.this.structuredOutputData.size() == 0 ? 0 : ((GridData)((StructuredLogPage)StructuredLogPage.this).structuredOutputData.get((int)n2)).data.size();
                    }

                    @Override
                    public Object getValueAt(int n, int n22) {
                        return StructuredLogPage.this.structuredOutputData.size() == 0 ? "N/A" : ((GridData)((StructuredLogPage)StructuredLogPage.this).structuredOutputData.get((int)n2)).data.get(n)[n22];
                    }
                };
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private void updateActiveTab(int n) {
        this.syncModels();
        if (n >= 0 && n != this.lastPos && n < this.models.length && this.models[n] != null) {
            this.lastPos = n;
            this.childTbl.setModel(this.models[n]);
            this.childTbl.invalidate();
        }
    }
}

