/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.plsql.language;

import oracle.dbtools.raptor.plsql.language.PLSQLBlockRenderer;
import oracle.dbtools.raptor.plsql.language.PLSQLLanguageSupport;
import oracle.dbtools.raptor.plsql.language.PLSQLStyles;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class PLSQLLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"plsql", "pls", "pks", "pkb", "pkh", "sql"};

    public String getPresentationName() {
        BundleHelper bundleHelper = EditorProperties.getEditorBundle();
        return bundleHelper.getString("PLSQL_MODULE_NAME");
    }

    public String[] getStyleNames() {
        return PLSQLStyles.STYLE_NAMES;
    }

    public String getContentSample() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- Create the department table first\n");
        stringBuffer.append("DROP TABLE dept;\n");
        stringBuffer.append("\n");
        stringBuffer.append("CREATE TABLE dept ( deptno NUMBER (2),\n");
        stringBuffer.append("                    dname VARCHAR2(10),\n");
        stringBuffer.append("                    loc VARCHAR2(9) );\n");
        stringBuffer.append("\n");
        stringBuffer.append("INSERT INTO dept VALUES ");
        stringBuffer.append("( 10, 'SALES', 'Boston' );\n");
        stringBuffer.append("SELECT cust_id\n");
        stringBuffer.append("  FROM (SELECT cust_id, rank() OVER (ORDER BY prob DESC, cust_id) rnk_clus2\n");
        stringBuffer.append("    FROM (SELECT cust_id, CLUSTER_PROBABILITY(km_sh_clus_sample, 2 USING *) prob\n");
        stringBuffer.append("          FROM mining_data_apply_v))\n");
        stringBuffer.append("WHERE rnk_clus2 <= 10\n");
        stringBuffer.append("ORDER BY rnk_clus2;\n");
        return stringBuffer.toString();
    }

    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    public void registerStyles(StyleRegistry styleRegistry) {
        new PLSQLStyles(styleRegistry);
    }

    public LanguageSupport createLanguageSupport() {
        return new PLSQLLanguageSupport();
    }

    public BlockRenderer createBlockRenderer(TextBuffer textBuffer) {
        return new PLSQLBlockRenderer(textBuffer);
    }
}

