/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.oviewer.base;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.controls.display.DisplayModel;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;
import oracle.ide.util.MenuSpec;
import oracle.javatools.util.ModelUtil;

class ViewerEditorAddin
extends EditorAddin {
    private static final float INIT_WEIGHT = 0.5f;
    private static final float DELTA_WEIGHT = 0.001f;
    private static Map<String, Float> sNextWeightByType = new HashMap<String, Float>();
    private final String m_label;
    private String m_connType;
    private String m_objType;
    private final Class<? extends Editor> m_editorClass;
    private float m_myWeight;
    private DisplayModel _model;

    private static float getWeight(String string) {
        Float f = sNextWeightByType.get(string);
        float f2 = f != null ? f.floatValue() : 0.5f;
        sNextWeightByType.put(string, Float.valueOf(f2 - 0.001f));
        return f2;
    }

    public String toString() {
        return DBObject.getKey(this.m_connType, this.m_objType);
    }

    public ViewerEditorAddin(String string, String string2, String string3, Class<? extends Editor> clazz) {
        this.m_label = string;
        this.m_connType = string2;
        this.m_objType = string3;
        this.m_editorClass = clazz;
        this.m_myWeight = ViewerEditorAddin.getWeight(string2);
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(this.m_label, null, null);
    }

    public Class getEditorClass() {
        return this.m_editorClass;
    }

    public boolean restoreAtStartup() {
        return false;
    }

    public float getEditorWeight() {
        return this.m_myWeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getEditorWeight(Element element) {
        ViewerNode viewerNode;
        DBObject dBObject = null;
        if (element instanceof ViewerNode && (dBObject = (viewerNode = (ViewerNode)element).getDBObject()) != null && dBObject.isValid() && dBObject.isConnected() && ModelUtil.areEqual((Object)DBObject.getKey(this.m_connType, this.m_objType), (Object)dBObject.getKey())) {
            Object object;
            Object object2;
            if (element instanceof PlSqlNode) {
                return Float.NaN;
            }
            DisplayModel displayModel = this.getModel();
            if (XMLBasedEditor.class.isAssignableFrom(this.m_editorClass) && (object2 = dBObject.getConnection(false)) != null && (object = displayModel.strictGetQuery((Connection)object2, true, true)) == null && Connections.getInstance().lock((Connection)object2, true)) {
                try {
                    if (displayModel.strictGetQuery((Connection)object2, true, false) == null) {
                        float f = Float.NaN;
                        return f;
                    }
                }
                finally {
                    Connections.getInstance().unlock((Connection)object2);
                }
            }
            if ((object2 = (String)displayModel.getExtValues().get("requiredProp")) != null) {
                object = ((String)object2).split(":")[0].toUpperCase();
                String string = ((String)object2).split(":")[1].toUpperCase();
                String string2 = (String)dBObject.getDictionary().get(object);
                if (string2 != null && !string2.equalsIgnoreCase(string)) {
                    return Float.NaN;
                }
            }
            if ("TABLE".equals(this.m_objType) && ("Data".equals(displayModel.getName()) || "SQL".equals(displayModel.getName())) && (object = (String)dBObject.getDictionary().get("GENERATED")) != null && ((String)object).equalsIgnoreCase("Y")) {
                return Float.NaN;
            }
            return this.m_myWeight;
        }
        return Float.NaN;
    }

    public DisplayModel getModel() {
        return this._model;
    }

    public void setModel(DisplayModel displayModel) {
        this._model = displayModel;
    }
}

