/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.db.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseContainer;
import oracle.dbtools.raptor.navigator.db.xml.AbstractFilterableItemInstance;
import oracle.dbtools.raptor.navigator.db.xml.FilterArguments;
import oracle.dbtools.raptor.navigator.db.xml.QueryAttributeInstance;
import oracle.dbtools.raptor.navigator.impl.DatabaseFolder;
import oracle.dbtools.raptor.navigator.impl.RefreshableFolder;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.DefaultContainer;

public class ObjectFolder
extends DefaultContainer
implements DatabaseFolder,
RefreshableFolder,
ViewableElement {
    private String m_cName;
    private String m_objType;
    private DBFolderInstance m_folder;

    public ObjectFolder(URL uRL) {
        this.setURL(uRL);
    }

    public void setFolderInstance(DBFolderInstance dBFolderInstance) {
        this.m_folder = dBFolderInstance;
    }

    public String getShortLabel() {
        return this.m_folder == null || this.m_folder.getDescriptor() == null ? "" : ((DatabaseContainer)this.m_folder.getDescriptor()).getLabel();
    }

    public static String getShortLabel(DBContainerInstance dBContainerInstance) {
        String string = ((DatabaseContainer)dBContainerInstance.getDescriptor()).getLabel();
        return dBContainerInstance.isFiltered() ? DatabaseNavigatorResources.format("FILTER_FORMAT", string) : string;
    }

    public String getToolTipText() {
        String string = ((DatabaseContainer)this.m_folder.getDescriptor()).getLabel();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (this.m_folder.isFiltered() && this.m_folder instanceof AbstractFilterableItemInstance) {
            FilterArguments filterArguments = ((AbstractFilterableItemInstance)((Object)this.m_folder)).getQueryArguments();
            if (filterArguments == null) {
                return super.getToolTipText();
            }
            stringBuffer.append(" (");
            for (QueryAttributeInstance queryAttributeInstance : filterArguments.getQueryArguments()) {
                stringBuffer.append(queryAttributeInstance.getAttribute().getName()).append(" ").append(queryAttributeInstance.getPredicate().toString()).append(" [");
                String[] stringArray = queryAttributeInstance.getValues();
                if (stringArray != null) {
                    for (String string2 : stringArray) {
                        stringBuffer.append(string2).append(", ");
                    }
                    stringBuffer.setLength(stringBuffer.length() - 2);
                }
                stringBuffer.append("], ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public Icon getIcon() {
        return this.m_folder.getDescriptor().getIcon();
    }

    public String getConnectionName() {
        return this.m_cName;
    }

    public DBFolderInstance getFolderInstance() {
        return this.m_folder;
    }

    @Override
    public void setProperty(String string, Object object) {
        this.m_folder.setProperty(string, object);
    }

    @Override
    public Object getProperty(String string) {
        Object object = null;
        object = "TYPE".equals(string) ? this.m_objType : ("ConnectionName".equals(string) ? this.m_cName : this.m_folder.getProperty(string));
        return object;
    }

    public String getObjectType() {
        return this.m_objType;
    }

    public void setURL(URL uRL) {
        super.setURL(uRL);
        this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_objType = DBURLFormatHelper.getBaseType(uRL);
    }

    public Object getProviderIdentifier() {
        return this.getConnectionName();
    }

    public String getProviderType() {
        return "db";
    }

    public String getStoreName() {
        return Connections.getStoreName(this.getConnectionName());
    }

    public String getSchemaName() {
        return (String)this.getProperty("SCHEMA");
    }
}

