/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.impl;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.impl.DatabaseFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.model.DefaultFolder;
import oracle.ide.model.Element;

public final class ChildFolder
extends DefaultFolder
implements DatabaseFolder {
    public static final String PARENT_NAME_KEY = "PARENT_NAME";
    public static final String PARENT_TYPE_KEY = "PARENT_TYPE";
    private URL m_url;
    private ChildType m_impl;
    private String m_cName;
    private String m_objType;
    private Map<String, Object> m_props = new HashMap<String, Object>();

    public ChildFolder(URL uRL, ChildType childType, Map<String, Object> map, List<Element> list) {
        this.m_impl = childType;
        this.setURL(uRL);
        this.m_objType = childType.getChildType();
        this._children.addAll(list);
        this.m_props.putAll(map);
    }

    public Icon getIcon() {
        Icon icon = this.m_impl.getFolderIcon();
        return icon != null ? icon : super.getIcon();
    }

    public String getShortLabel() {
        return this.m_impl.getFolderLabel();
    }

    public URL getURL() {
        return this.m_url;
    }

    public void setURL(URL uRL) {
        this.m_cName = DBURLFormatHelper.getConnectionName(uRL);
        this.m_url = uRL;
    }

    public String getObjectType() {
        return this.m_objType;
    }

    public String getSchemaName() {
        return DBURLFormatHelper.getSchema(this.m_url);
    }

    public Object getProviderIdentifier() {
        return this.m_cName;
    }

    public String getProviderType() {
        return "db";
    }

    public String getStoreName() {
        return Connections.getStoreName(this.m_cName);
    }

    @Override
    public void setProperty(String string, Object object) {
        this.m_props.put(string, object);
    }

    @Override
    public Object getProperty(String string) {
        if ("ConnectionName".equals(string)) {
            return this.getProviderIdentifier();
        }
        if ("TYPE".equals(string)) {
            return this.getObjectType();
        }
        return this.m_props.get(string);
    }
}

