/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.ObjectCategory;
import oracle.dbtools.raptor.navigator.db.xml.NavigatorDescriptor;
import oracle.dbtools.raptor.navigator.db.xml.XmlFolderOwner;
import oracle.dbtools.xml.navigator.CategoryElement;
import oracle.dbtools.xml.navigator.FolderOwner;
import oracle.ide.model.Element;

class XmlCategoryType
extends XmlFolderOwner
implements ObjectCategory {
    private final String m_category;
    private final DatabaseFolder m_folder;
    private final Version m_minVer;
    private final Version m_maxVer;
    private final Set<String> m_reqObjects;
    private final Set<String> m_reqFeatures;
    private final boolean m_ignoreComparator;

    XmlCategoryType(String string, String string2, NavigatorDescriptor navigatorDescriptor, CategoryElement categoryElement) {
        super(string, navigatorDescriptor, (FolderOwner)categoryElement);
        this.m_category = string2;
        DatabaseFolder[] databaseFolderArray = this.getFoldersImpl();
        this.m_folder = databaseFolderArray.length > 0 ? databaseFolderArray[0] : null;
        this.m_minVer = categoryElement.getMinimumVersion();
        this.m_maxVer = categoryElement.getMaximumVersion();
        this.m_reqObjects = new HashSet<String>(categoryElement.getRequiredObjects());
        this.m_reqFeatures = new HashSet<String>(categoryElement.getRequiredFeatures());
        this.m_ignoreComparator = categoryElement.isIgnoreComparator();
    }

    @Override
    public String getType() {
        return this.m_category;
    }

    @Override
    boolean isIncludesSynonyms() {
        return false;
    }

    @Override
    public String getLabel() {
        return this.m_folder != null ? this.m_folder.getLabel() : "";
    }

    @Override
    public Icon getIcon() {
        return this.m_folder != null ? this.m_folder.getIcon() : null;
    }

    @Override
    public Class<? extends Element> getImplementationClass() {
        return null;
    }

    Version getMinimumVersion() {
        return this.m_minVer;
    }

    Version getMaximumVersion() {
        return this.m_maxVer;
    }

    Set<String> getRequiredObjects() {
        return Collections.unmodifiableSet(this.m_reqObjects);
    }

    Set<String> getRequiredFeatures() {
        return Collections.unmodifiableSet(this.m_reqFeatures);
    }
}

