/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.xml;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.navigator.ObjectQueryInstance;
import oracle.dbtools.raptor.navigator.db.model.DBContainerInstance;
import oracle.dbtools.raptor.navigator.db.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseContainer;
import oracle.dbtools.raptor.navigator.db.xml.AbstractItemInstance;
import oracle.dbtools.raptor.navigator.db.xml.FilterArguments;
import oracle.dbtools.raptor.navigator.db.xml.FilterCache;
import oracle.dbtools.raptor.navigator.db.xml.Predicate;
import oracle.dbtools.raptor.navigator.db.xml.QueryAttributeInstance;
import oracle.dbtools.raptor.navigator.db.xml.XmlObjectFactory;
import oracle.dbtools.raptor.navigator.db.xml.XmlSchemaInstance;
import oracle.dbtools.raptor.navigator.filter.FilterAndSortPanel;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Column;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryParameter;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;

public abstract class AbstractFilterableItemInstance
extends AbstractItemInstance
implements DBContainerInstance {
    private static final String TYPE_KEY = "TYPE";
    private static final String COMPLEX_PREDICATE_KEY = "COMPLEX_PREDICATE";
    private static final String PROTOCOL_KEY = "PROTOCOL";
    private static final String CATALOG_KEY = "CATALOG";
    private static final String SCHEMA_KEY = "SCHEMA";
    static final String ARG_NAME_KEY = "ARG_NAME";
    static final String ARG_PRED_KEY = "ARG_PRED";
    static final String ARG_VALS_KEY = "ARG_VALS";
    static final String ARG_CASE_KEY = "ARG_CASE";
    static final String ARG_MATCH_ANY_KEY = "ARG_MATCH_ANY";
    static final String ARG_INCLUDE_SYNS_KEY = "ARG_INCLUDE_SYNS";
    private static Map<String, FilterArguments> s_argMap = new HashMap<String, FilterArguments>();
    private Query m_query;
    private String m_key;
    private String m_schemaKey;
    private FilterArguments m_filterArgs;
    private Collection<QueryParameter> m_params;

    protected AbstractFilterableItemInstance(XmlObjectFactory xmlObjectFactory, DatabaseContainer databaseContainer, Query query) {
        super(xmlObjectFactory);
        this.setDescriptor(databaseContainer);
        this.m_query = query;
    }

    protected Query getQuery() {
        return this.m_query;
    }

    @Override
    public boolean promptForFilter() {
        boolean bl = false;
        FilterArguments filterArguments = this.getQueryArguments();
        FilterAndSortPanel filterAndSortPanel = new FilterAndSortPanel();
        Namespace namespace = new Namespace();
        namespace.put("FilterCommand.QUERY", (Object)this.m_query);
        namespace.put("FilterCommand.ARGS", (Object)filterArguments);
        namespace.put("FilterAndSortPanel.FILTER_DETAILS_KEY", (Object)this.getObjectFactory().getConnectionTypeDescriptor().getImpl().getFilterDetails());
        String string = "Filter";
        filterAndSortPanel.setHelpID("f1_navfilters_html");
        TDialogLauncher tDialogLauncher = new TDialogLauncher((Component)Ide.getMainWindow(), string, (Traversable)filterAndSortPanel, namespace);
        JEWTDialog jEWTDialog = tDialogLauncher.initDialog();
        jEWTDialog.setInitialFocus(filterAndSortPanel.getInitialFocusComponent());
        if (tDialogLauncher.showDialog()) {
            this.setQueryArguments((FilterArguments)namespace.find("FilterCommand.ARGS"));
            bl = true;
        }
        tDialogLauncher.dispose();
        return bl;
    }

    @Override
    public boolean isFiltered() {
        if (this.m_filterArgs == null) {
            this.initFilter();
        }
        return this.m_filterArgs.isFiltered();
    }

    @Override
    public void clearFilter() {
        this.setQueryArguments(null);
    }

    @Override
    public boolean canHaveFilter() {
        return this.getFilterableParameters().size() > 0;
    }

    protected ObjectQueryInstance getQueryInstance(DBItemInstance dBItemInstance, boolean bl) {
        Object object;
        ObjectQueryInstance objectQueryInstance = new ObjectQueryInstance(this.getType(), this.m_query);
        if (dBItemInstance != null) {
            for (String object2 : dBItemInstance.getPropertyKeys()) {
                object = dBItemInstance.getProperty(object2);
                objectQueryInstance.setRequiredValue(object2, object);
            }
        } else {
            for (String string : this.getPropertyKeys()) {
                objectQueryInstance.setRequiredValue(string, this.getProperty(string));
            }
        }
        Object object3 = null;
        if (!bl) {
            FilterArguments filterArguments = this.getQueryArguments();
            object = filterArguments.getQueryArguments();
            int n = ((QueryAttributeInstance[])object).length;
            for (int i = 0; i < n; ++i) {
                QueryAttributeInstance queryAttributeInstance = object[i];
                objectQueryInstance.addOptionalArgument(queryAttributeInstance);
            }
            objectQueryInstance.setMatchAny(filterArguments.isMatchAny());
            if (filterArguments.isIncludeSynonyms()) {
                object3 = 1;
            }
            if (!filterArguments.isOverrideSchemaFilter() && (object = this.getSchemaFilter()) != null) {
                QueryParameter queryParameter = ((QueryAttributeInstance)object).getAttribute();
                String string = queryParameter.getName();
                for (Column column : this.m_query.getCols()) {
                    if (!string.equals(column.getID())) continue;
                    object = new QueryAttributeInstance((QueryParameter)column, ((QueryAttributeInstance)object).getPredicate(), ((QueryAttributeInstance)object).getValues(), ((QueryAttributeInstance)object).isCaseSensitive());
                    break;
                }
                objectQueryInstance.setSchemaFilter((QueryAttributeInstance)object);
            }
        }
        objectQueryInstance.setRequiredValue("INCLUDE_SYNS", object3);
        return objectQueryInstance;
    }

    QueryAttributeInstance getSchemaFilter() {
        return XmlSchemaInstance.getSchemaFilter(this.getSchemaKey());
    }

    void setQueryArguments(FilterArguments filterArguments) {
        this.m_filterArgs = filterArguments == null ? this.createDefaultFilter() : (FilterArguments)filterArguments.copyTo(null);
        this.persistFilter();
    }

    protected FilterArguments createDefaultFilter() {
        FilterArguments filterArguments = new FilterArguments();
        return filterArguments;
    }

    public FilterArguments getQueryArguments() {
        if (this.m_filterArgs == null) {
            this.initFilter();
        }
        return (FilterArguments)this.m_filterArgs.copyTo(null);
    }

    protected final void initFilter() {
        this.m_filterArgs = s_argMap.get(this.getKey());
        if (this.m_filterArgs == null) {
            this.m_filterArgs = this.createDefaultFilter();
            this.initFilterImpl(this.m_filterArgs);
        }
    }

    private Collection<QueryParameter> getFilterableParameters() {
        if (this.m_params == null) {
            Column column;
            Object object;
            ArrayList<QueryParameter> arrayList = new ArrayList<QueryParameter>();
            List list = this.m_query.getCols();
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    column = (Column)object.next();
                    if (!column.isFilterable()) continue;
                    arrayList.add((QueryParameter)column);
                }
            }
            if ((object = this.m_query.getBinds()) != null) {
                column = object.iterator();
                while (column.hasNext()) {
                    Bind bind = (Bind)column.next();
                    if (!bind.isFilterable()) continue;
                    arrayList.add((QueryParameter)bind);
                }
            }
            this.m_params = arrayList;
        }
        return this.m_params;
    }

    protected void initFilterImpl(FilterArguments filterArguments) {
        HashMap<String, QueryParameter> hashMap = new HashMap<String, QueryParameter>();
        ArrayList<QueryParameter> arrayList = new ArrayList<QueryParameter>();
        for (QueryParameter object2 : this.getFilterableParameters()) {
            hashMap.put(object2.getName(), object2);
            if (!object2.isDefaultFilter() || !COMPLEX_PREDICATE_KEY.equals(object2.getType())) continue;
            arrayList.add(object2);
        }
        ArrayList arrayList2 = new ArrayList();
        List<Map<String, Object>> list = FilterCache.getInstance((PropertyStorage)Preferences.getPreferences()).getFilterArguments(this.getKey());
        if (list != null) {
            for (Map<String, Object> queryParameter : list) {
                if (queryParameter.containsKey(ARG_MATCH_ANY_KEY)) {
                    filterArguments.setMatchAny((Boolean)queryParameter.get(ARG_MATCH_ANY_KEY));
                    continue;
                }
                if (queryParameter.containsKey(ARG_INCLUDE_SYNS_KEY)) {
                    filterArguments.setIncludeSynonyms((Boolean)queryParameter.get(ARG_INCLUDE_SYNS_KEY));
                    continue;
                }
                String string = (String)queryParameter.get(ARG_NAME_KEY);
                QueryParameter queryParameter2 = (QueryParameter)hashMap.get(string);
                if (queryParameter2 == null) continue;
                arrayList2.add(new QueryAttributeInstance(queryParameter2, Predicate.valueOf((String)queryParameter.get(ARG_PRED_KEY)), (String[])queryParameter.get(ARG_VALS_KEY), Boolean.valueOf((String)queryParameter.get(ARG_CASE_KEY))));
            }
        } else if (arrayList.size() > 0) {
            for (QueryParameter queryParameter : arrayList) {
                arrayList2.add(new QueryAttributeInstance(queryParameter, Predicate.COMPLEX, new String[0], true));
            }
        }
        filterArguments.setQueryArguments(arrayList2.toArray(new QueryAttributeInstance[arrayList2.size()]));
    }

    protected void persistFilter() {
        s_argMap.put(this.getKey(), this.m_filterArgs);
        if (this.m_filterArgs != null) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            arrayList.add(Collections.singletonMap(ARG_MATCH_ANY_KEY, this.m_filterArgs.isMatchAny()));
            arrayList.add(Collections.singletonMap(ARG_INCLUDE_SYNS_KEY, this.m_filterArgs.isIncludeSynonyms()));
            for (QueryAttributeInstance queryAttributeInstance : this.m_filterArgs.getQueryArguments()) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put(ARG_NAME_KEY, queryAttributeInstance.getAttribute().getName());
                hashMap.put(ARG_PRED_KEY, queryAttributeInstance.getPredicate().name());
                hashMap.put(ARG_VALS_KEY, queryAttributeInstance.getValues());
                hashMap.put(ARG_CASE_KEY, Boolean.toString(queryAttributeInstance.isCaseSensitive()));
                arrayList.add(hashMap);
            }
            FilterCache.getInstance((PropertyStorage)Preferences.getPreferences()).setFilterArguments(this.getKey(), arrayList);
        }
    }

    protected final String getKey() {
        if (this.m_key == null) {
            String string = (String)this.getProperty(PROTOCOL_KEY);
            if (string == null) {
                string = "sqldev.nav";
            }
            String string2 = this.getObjectFactory().getConnectionName();
            String string3 = (String)this.getProperty(CATALOG_KEY);
            String string4 = (String)this.getProperty(SCHEMA_KEY);
            String string5 = this.getType();
            this.m_key = AbstractFilterableItemInstance.createKey(string, string2, string3, string4, string5);
        }
        return this.m_key;
    }

    protected String getSchemaKey() {
        if (this.m_schemaKey == null) {
            this.m_schemaKey = AbstractFilterableItemInstance.createSchemaKey(this);
        }
        return this.m_schemaKey;
    }

    static String createSchemaKey(DBItemInstance dBItemInstance) {
        String string = (String)dBItemInstance.getProperty(PROTOCOL_KEY);
        if (string == null) {
            string = "sqldev.nav";
        }
        String string2 = dBItemInstance.getObjectFactory().getConnectionName();
        String string3 = (String)dBItemInstance.getProperty(CATALOG_KEY);
        String string4 = (String)dBItemInstance.getProperty(SCHEMA_KEY);
        return AbstractFilterableItemInstance.createKey(string, string2, string3, string4);
    }

    public String getType() {
        return (String)this.getProperty(TYPE_KEY);
    }

    private static final String createKey(String string, String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        for (String string2 : stringArray) {
            stringBuilder.append('|');
            if (string2 == null) {
                string2 = "";
            }
            stringBuilder.append(DBURLFormatHelper.encode(string2));
        }
        return stringBuilder.toString();
    }
}

