/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.db.impl;

import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.db.impl.ObjectFolderTreeNode;
import oracle.dbtools.raptor.navigator.db.model.ChildType;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.db.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.db.model.DatabaseObject;
import oracle.dbtools.raptor.navigator.db.model.FilterChildProvider;
import oracle.dbtools.raptor.navigator.db.model.ObjectType;
import oracle.dbtools.raptor.navigator.impl.ChildFolder;
import oracle.dbtools.raptor.navigator.impl.DatabaseNavigatorElementFactory;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.AsynchronousNavigatorTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorQueryTask;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;

public class DatabaseObjectTreeNode
extends AsynchronousNavigatorTreeNode {
    private List<FilterChildProvider> m_providers = new ArrayList<FilterChildProvider>();

    public DatabaseObjectTreeNode() {
        this.setComparator(null);
    }

    @Override
    protected RaptorTask<Collection<Element>> getLoadingTask() {
        DatabaseNode databaseNode = (DatabaseNode)this.getElement();
        return new LoadTask(databaseNode, (String)databaseNode.getProviderIdentifier());
    }

    private class LoadTask
    extends NavigatorQueryTask {
        private DatabaseNode m_dbNode;

        LoadTask(DatabaseNode databaseNode, String string) {
            super("Loading Children", string, true);
            this.m_dbNode = databaseNode;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected Collection<Element> doWorkImpl() throws TaskException {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            URL uRL = this.m_dbNode.getURL();
            DBObjectInstance dBObjectInstance = this.m_dbNode.getNodeInstance();
            DatabaseObject databaseObject = (DatabaseObject)dBObjectInstance.getDescriptor();
            try {
                try {
                    for (ChildType childType : databaseObject.getChildTypes()) {
                        Object object;
                        this.checkCanProceed();
                        List<Element> list = null;
                        Class<? extends FilterChildProvider> clazz = databaseObject.getChildProvider(childType.getChildType());
                        if (clazz != null) {
                            object = null;
                            assert (FilterChildProvider.class.isAssignableFrom(clazz));
                            try {
                                FilterChildProvider filterChildProvider = clazz.newInstance();
                                DatabaseObjectTreeNode.this.m_providers.add(filterChildProvider);
                                object = filterChildProvider.listChildren(this.m_dbNode, childType.getChildType());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            list = this.createChildElements(uRL, childType, (List<? extends DBChildInstance>)object);
                        } else {
                            Object object2;
                            object = childType.getNodeType();
                            if (object != null) {
                                DatabaseFolder databaseFolder;
                                DBFolderInstance dBFolderInstance;
                                DatabaseFolder[] databaseFolderArray;
                                ObjectType objectType;
                                boolean bl = childType.hasChildListOverride();
                                if (!bl && (objectType = ((ObjectFactory)(object2 = dBObjectInstance.getObjectFactory())).getObjectType((String)object)) != null && (databaseFolderArray = objectType.getFolders()) != null && databaseFolderArray.length > 0 && (dBFolderInstance = ((ObjectFactory)object2).createFolderInstance((String)object, databaseFolder = databaseFolderArray[0])) != null) {
                                    for (String string : dBObjectInstance.getPropertyKeys()) {
                                        void var19_30;
                                        Object object3 = dBObjectInstance.getProperty(string);
                                        if ("TYPE".equals(string)) {
                                            String string2 = "PARENT_TYPE";
                                        } else if ("NAME".equals(string)) {
                                            String string3 = "PARENT_NAME";
                                        }
                                        dBFolderInstance.setProperty((String)var19_30, object3);
                                    }
                                    URL uRL2 = DBURLFormatHelper.getEnclosedTypeURL(uRL, (String)object);
                                    if (childType.showAsFolder()) {
                                        Folder folder = DatabaseNavigatorElementFactory.getTypeFolder(uRL2, dBFolderInstance);
                                        list = Collections.singletonList(folder);
                                    } else {
                                        this.checkCanProceed();
                                        list = new ArrayList<Element>();
                                        for (Object object3 : dBFolderInstance.listChildren(new ObjectFolderTreeNode.FolderQueryProgressListener(this))) {
                                            this.checkCanProceed();
                                            DBObjectInstance dBObjectInstance2 = (DBObjectInstance)object3;
                                            DatabaseNode databaseNode = DatabaseNavigatorElementFactory.createObjectNode(uRL2, dBObjectInstance2);
                                            if (databaseNode == null) continue;
                                            list.add(databaseNode);
                                        }
                                    }
                                }
                                if (list == null) {
                                    list = this.createChildElements(uRL, childType, dBObjectInstance.listChildren(childType.getChildType()));
                                }
                            } else if (childType.showAsFolder()) {
                                URL uRL3 = DBURLFormatHelper.getChildURL(uRL, childType.getChildType(), null);
                                object2 = new HashMap();
                                object2.put("PARENT_NAME", dBObjectInstance.getProperty("NAME"));
                                object2.put("PARENT_TYPE", dBObjectInstance.getProperty("TYPE"));
                                list = Collections.singletonList(new ChildFolder(uRL3, childType, (Map<String, Object>)object2, this.createChildElements(uRL, childType, dBObjectInstance.listChildren(childType.getChildType()))));
                            } else {
                                list = this.createChildElements(uRL, childType, dBObjectInstance.listChildren(childType.getChildType()));
                            }
                        }
                        if (list == null) continue;
                        arrayList.addAll(list);
                    }
                }
                catch (SQLException sQLException) {
                    this.checkCanProceed();
                    ExceptionHandler.handleException((Throwable)sQLException);
                }
            }
            catch (AbortException abortException) {
                arrayList.clear();
            }
            catch (ExecutionException executionException) {
                arrayList.clear();
            }
            return arrayList;
        }

        protected List<Element> createChildElements(URL uRL, ChildType childType, List<? extends DBChildInstance> list) throws ExecutionException {
            if (list == null) {
                return Collections.emptyList();
            }
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (DBChildInstance dBChildInstance : list) {
                this.checkCanProceed();
                String string = (String)dBChildInstance.getProperty("NAME");
                if (string == null) continue;
                arrayList.add(DatabaseNavigatorElementFactory.createChildElement(uRL, childType.getChildType(), dBChildInstance));
            }
            return arrayList;
        }
    }
}

