/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.core;

import java.util.Iterator;
import oracle.dbtools.raptor.navigator.core.NavigatorContext;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.dbtools.raptor.navigator.db.impl.ConnectionStoresTreeNode;
import oracle.dbtools.raptor.navigator.model.NavigatorTree;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.util.GCTracker;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

final class NavigatorViewController
implements Controller {
    public static final String COLLAPSE_ALL_NODES_CMD = "Navigator.COLLAPSE_ALL_NODES";
    public static final int COLLAPSE_ALL_NODES_CMD_ID = Ide.findOrCreateCmdID((String)"Navigator.COLLAPSE_ALL_NODES");
    private NavigatorWindow m_view;

    NavigatorViewController(NavigatorWindow navigatorWindow) {
        this.m_view = navigatorWindow;
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (context.getView() == this.m_view) {
            int n = ideAction.getCommandId();
            if (n == 51) {
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
                if (navigatorTreeNode != null) {
                    this.m_view.getTree().refresh(navigatorTreeNode);
                    if (navigatorTreeNode.getParent() instanceof ConnectionStoresTreeNode) {
                        System.gc();
                        GCTracker.getInstance().pollReferentReapQueue();
                    }
                }
                bl = true;
            } else if (n == COLLAPSE_ALL_NODES_CMD_ID) {
                this.collapseAllNodes();
                bl = true;
            }
        }
        return bl;
    }

    public boolean update(IdeAction ideAction, Context context) {
        boolean bl = false;
        if (context.getView() == this.m_view) {
            int n = ideAction.getCommandId();
            if (n == 51) {
                boolean bl2 = false;
                NavigatorTreeNode navigatorTreeNode = NavigatorContext.getSingleNavigatorTreeNodeFromContext(context);
                bl2 = navigatorTreeNode != null && !navigatorTreeNode.isLeaf();
                ideAction.setEnabled(bl2);
                bl = true;
            } else if (n == COLLAPSE_ALL_NODES_CMD_ID) {
                ideAction.setEnabled(true);
                bl = true;
            }
        }
        return bl;
    }

    private void collapseAllNodes() {
        NavigatorTree navigatorTree = this.m_view.getTree();
        NavigatorTreeNode navigatorTreeNode = navigatorTree.getRoot();
        this.collapseNode(navigatorTree, navigatorTreeNode);
    }

    private void collapseNode(NavigatorTree navigatorTree, NavigatorTreeNode navigatorTreeNode) {
        if (this.m_view.canCollapse(navigatorTreeNode)) {
            navigatorTree.collapse(navigatorTreeNode, false);
        } else if (navigatorTreeNode.getChildCount() > 0) {
            Iterator<NavigatorTreeNode> iterator = navigatorTreeNode.getChildNodes();
            while (iterator.hasNext()) {
                this.collapseNode(navigatorTree, iterator.next());
            }
        }
    }
}

