/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator.core;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.core.NavigatorWindow;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.ContextMenuListenerSupport;
import oracle.ide.controller.ContextMenuListenersHook;
import oracle.ide.layout.ViewId;
import oracle.ide.util.MnemonicSolver;
import oracle.javatools.util.Pair;

public abstract class NavigatorManager {
    private static final String GLOBAL_NAVIGATOR_SITE_ID = "sqldev.nav";
    private static ContextMenuListenerSupport s_globalContextMenuSupport;
    private static final String TOOLBAR_VISIBLE_PROP = ".Toolbar.visible";
    private NavigatorWindow m_window;
    private ContextMenu m_ctxMenu;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContextMenuListenerSupport getSharedContextMenuListenerSupport() {
        boolean bl = false;
        Class<NavigatorWindow> clazz = NavigatorWindow.class;
        synchronized (NavigatorWindow.class) {
            if (s_globalContextMenuSupport == null) {
                s_globalContextMenuSupport = ContextMenuListenerSupport.createInstance();
                bl = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (bl) {
                NavigatorManager.loadListenerHooks(s_globalContextMenuSupport, new String[]{GLOBAL_NAVIGATOR_SITE_ID});
            }
            return s_globalContextMenuSupport;
        }
    }

    private static void loadListenerHooks(ContextMenuListenerSupport contextMenuListenerSupport, String[] stringArray) {
        ContextMenuListenersHook contextMenuListenersHook = (ContextMenuListenersHook)ExtensionRegistry.getExtensionRegistry().getHook(ContextMenuListenersHook.ELEMENT);
        if (contextMenuListenersHook != null) {
            for (String string : stringArray) {
                contextMenuListenerSupport.addContextMenuListener(contextMenuListenersHook.getListener(string), null);
            }
        }
    }

    public final NavigatorWindow getNavigatorWindow() {
        if (this.m_window == null) {
            this.m_window = this.createNavigatorWindow();
            this.m_window.setToolbarVisible(this.isToolbarVisible());
            this.m_window.setContextMenu(this.getContextMenu());
        }
        return this.m_window;
    }

    public final ContextMenu getContextMenu() {
        if (this.m_ctxMenu == null) {
            final ContextMenuListenerSupport contextMenuListenerSupport = ContextMenuListenerSupport.createInstance();
            String[] stringArray = this.getNavigatorSiteIDs();
            if (stringArray != null && stringArray.length > 0) {
                NavigatorManager.loadListenerHooks(contextMenuListenerSupport, stringArray);
            }
            this.m_ctxMenu = new ContextMenu(new MnemonicSolver(), new ContextMenuListenerSupport(){
                final ContextMenuListenerSupport sharedInstance = NavigatorManager.access$000();
                final ContextMenuListenerSupport instanceInstance = contextMenuListenerSupport;

                public void addContextMenuListener(ContextMenuListener contextMenuListener, Class clazz) {
                    this.instanceInstance.addContextMenuListener(contextMenuListener, clazz);
                }

                public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
                    this.instanceInstance.removeContextMenuListener(contextMenuListener);
                }

                public List<Pair<Class, ContextMenuListener>> getContextMenuListeners() {
                    ArrayList<Pair<Class, ContextMenuListener>> arrayList = new ArrayList<Pair<Class, ContextMenuListener>>();
                    arrayList.addAll(this.sharedInstance.getContextMenuListeners());
                    arrayList.addAll(this.instanceInstance.getContextMenuListeners());
                    return arrayList;
                }
            });
            UIUtils.addMnemonicSolver((ContextMenu)this.m_ctxMenu);
        }
        return this.m_ctxMenu;
    }

    protected String[] getNavigatorSiteIDs() {
        return null;
    }

    protected abstract NavigatorWindow createNavigatorWindow();

    public abstract ViewId getViewId();

    private String getToolbarKey() {
        return this.getViewId().getType() + TOOLBAR_VISIBLE_PROP;
    }

    public boolean isToolbarVisible() {
        String string = Ide.getProperty((String)this.getToolbarKey(), (String)Boolean.TRUE.toString());
        return Boolean.valueOf(string);
    }

    public void setToolbarVisible(boolean bl) {
        Ide.setProperty((String)this.getToolbarKey(), (String)Boolean.toString(bl));
        if (this.m_window != null) {
            this.m_window.setToolbarVisible(bl);
        }
    }

    static /* synthetic */ ContextMenuListenerSupport access$000() {
        return NavigatorManager.getSharedContextMenuListenerSupport();
    }
}

