/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.navigator.db.AbstractConnectionNode;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseSourceNode;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.explorer.IconOverlayTracker;
import oracle.ide.model.Element;
import oracle.javatools.db.DBException;
import oracle.javatools.icons.OracleIcons;

public final class DatabaseOverlayClient {
    private static final int OVERLAY_BATCH_SIZE = 10;
    public static final String INFO_TYPE_ID = "jdbcNodeInfoType";
    private static IconOverlayTracker s_tracker;
    private static final Icon debugOverlayIcon;

    public static final IconOverlayTracker getTracker() {
        DatabaseOverlayClient.initializeOverlays();
        return s_tracker;
    }

    private DatabaseOverlayClient() {
    }

    static synchronized void initializeOverlays() {
        if (s_tracker == null) {
            s_tracker = new NodeOverlayTracker();
        }
    }

    public static final void updateOverlay(Element element) {
        IconOverlayTracker iconOverlayTracker = DatabaseOverlayClient.getTracker();
        if (iconOverlayTracker != null) {
            iconOverlayTracker.validateOverlay(element);
            iconOverlayTracker.repaintOverlays();
        }
    }

    public static Icon getDebugOverlay(DatabaseNode databaseNode) {
        if (databaseNode instanceof PlSqlNode) {
            Object object;
            int n = 12;
            try {
                object = (PlSqlNode)databaseNode;
                Connection connection = Connections.getInstance().getConnection(((DatabaseSourceNode)object).getConnectionName());
                if (connection != null) {
                    n = connection.getMetaData().getDatabaseMajorVersion();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
            }
            if (n <= 11) {
                object = (String)databaseNode.getProperty("PLSQL_DEBUG");
                if (Boolean.parseBoolean((String)object)) {
                    return debugOverlayIcon;
                }
            } else {
                object = databaseNode.getProperty("PLSQL_OPTIMIZE_LEVEL");
                if (object instanceof BigDecimal && ((BigDecimal)object).intValue() <= 1) {
                    return debugOverlayIcon;
                }
                if (object instanceof Integer && (Integer)object <= 1) {
                    return debugOverlayIcon;
                }
                if (object instanceof String && Integer.parseInt((String)object) <= 1) {
                    return debugOverlayIcon;
                }
            }
        }
        return null;
    }

    static {
        debugOverlayIcon = RaptorImagesArb.getIcon("BUG_OVERLAY");
    }

    private static final class NodeOverlayTracker
    extends IconOverlayTracker {
        private static final IconOverlay INVALID_OVERLAY_INFORMATION = new IconOverlay(RaptorImagesArb.getIcon("INVALID"), null, null);
        private static final IconOverlay CONNECTED_OVERLAY_INFORMATION = new IconOverlay(RaptorImagesArb.getIcon("PLUG_OVERLAY"), null, null);
        private static final IconOverlay FILTER_OVERLAY_INFORMATION = new IconOverlay(OracleIcons.getIcon((String)"overlay/filter.png"), null, null);
        private static final IconOverlay PUB_SYN_OVERLAY_INFORMATION = new IconOverlay(OracleIcons.getIcon((String)"publicsynonym.png"), null, null);
        private static final IconOverlay PLSQL_DEBUG_INFORMATION = new IconOverlay(DatabaseOverlayClient.access$100(), null, null);

        private NodeOverlayTracker() {
            super(DatabaseOverlayClient.INFO_TYPE_ID, IconOverlayCache.getInstance(), 10);
        }

        protected boolean isControlled(Element element) {
            return element instanceof DatabaseConnection || element instanceof DatabaseNode || element instanceof ObjectFolder || element instanceof OtherSchemasFolder;
        }

        protected IconOverlay[] getOverlays(Element[] elementArray) {
            ArrayList<IconOverlay> arrayList = new ArrayList<IconOverlay>(elementArray.length);
            for (int i = 0; i < elementArray.length; ++i) {
                Object object;
                Element element = elementArray[i];
                IconOverlay iconOverlay = null;
                if (element instanceof DatabaseNode) {
                    object = (DatabaseNode)element;
                    String string = (String)object.getProperty("INVALID");
                    if (Boolean.parseBoolean(string)) {
                        iconOverlay = INVALID_OVERLAY_INFORMATION;
                    } else if ("SYNONYM".equals(object.getProperty("TYPE")) && "PUBLIC".equals(object.getProperty("SCHEMA"))) {
                        iconOverlay = PUB_SYN_OVERLAY_INFORMATION;
                    }
                    if (iconOverlay == null && debugOverlayIcon == DatabaseOverlayClient.getDebugOverlay((DatabaseNode)object)) {
                        iconOverlay = PLSQL_DEBUG_INFORMATION;
                    }
                } else if (element instanceof DatabaseConnection) {
                    object = (DatabaseConnection)element;
                    if (((AbstractConnectionNode)object).isConnectionOpen()) {
                        iconOverlay = CONNECTED_OVERLAY_INFORMATION;
                    }
                } else if (element instanceof ObjectFolder) {
                    object = ((ObjectFolder)element).getFolderInstance();
                    if (object != null && object.isFiltered()) {
                        iconOverlay = FILTER_OVERLAY_INFORMATION;
                    }
                } else if (element instanceof OtherSchemasFolder && (object = ((OtherSchemasFolder)element).getDBSchemasInstance()) != null && object.isFiltered()) {
                    iconOverlay = FILTER_OVERLAY_INFORMATION;
                }
                arrayList.add(iconOverlay);
            }
            return arrayList.toArray(new IconOverlay[0]);
        }
    }
}

