/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Bounds;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javax.swing.Box;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.metrics.panel.MetricsPanel;
import oracle.dbtools.raptor.metrics.viewer.AbstractPanelAdapter;
import oracle.ide.controls.Toolbar;

public class MetricsToolbarAdapter
extends AbstractPanelAdapter {
    private volatile JFXPanel fxPanel;
    private MetricsPanel metricsPanel;
    private Scene scene;
    private final ClassLoader classLoader;
    private final String panelFxml;
    private final String toolbarFxml;
    private final String bundle;
    private final String css;
    private final String connectionName;

    public MetricsToolbarAdapter(ClassLoader classLoader, String string, String string2, String string3, String string4, String string5) {
        super(new BorderLayout());
        this.classLoader = classLoader;
        this.panelFxml = string;
        this.toolbarFxml = string2;
        this.bundle = string3;
        this.css = string4;
        this.connectionName = string5;
        this.fxPanel = new JFXPanel();
        this.add((Component)this.fxPanel);
    }

    public void openToolbarUI(Toolbar toolbar) {
        this.setPreferredSize(new Dimension(0, 0));
        this.setMaximumSize(new Dimension(0, 0));
        Platform.runLater(() -> this.prepareToolbarUI(toolbar));
    }

    private void prepareToolbarUI(final Toolbar toolbar) {
        this.metricsPanel = MetricsPanel.newBuilder(this.classLoader, this.panelFxml, this.toolbarFxml).bundleBaseName(this.bundle).css(this.css).connectionName(this.connectionName).build();
        StackPane stackPane = new StackPane(){
            private boolean populated = false;

            protected void layoutChildren() {
                super.layoutChildren();
                Bounds bounds = MetricsToolbarAdapter.this.metricsPanel.getLayoutBounds();
                double d = bounds.getWidth();
                double d2 = bounds.getHeight();
                if (d > 0.0 && d2 > 0.0) {
                    SwingUtilities.invokeLater(() -> {
                        Dimension dimension = new Dimension((int)d, (int)d2);
                        MetricsToolbarAdapter.this.setPreferredSize(dimension);
                        MetricsToolbarAdapter.this.setMaximumSize(dimension);
                        MetricsToolbarAdapter.this.setMinimumSize(dimension);
                        if (!this.populated) {
                            toolbar.add(Box.createHorizontalGlue());
                            toolbar.add((Component)MetricsToolbarAdapter.this);
                            this.populated = true;
                        }
                        toolbar.revalidate();
                        toolbar.repaint();
                    });
                }
            }
        };
        stackPane.getChildren().add((Object)this.metricsPanel);
        this.scene = new Scene((Parent)stackPane);
        String string = this.metricsPanel.getPathResolver().process(this.css);
        String string2 = this.classLoader.getResource(string).toExternalForm();
        this.scene.getStylesheets().add((Object)string2);
        this.addUserStylesheet(this.scene);
        this.fxPanel.setScene(this.scene);
        this.metricsPanel.start();
        stackPane.applyCss();
        stackPane.layout();
    }

    public void closeToolbarUI() {
        Platform.runLater(() -> {
            this.metricsPanel.close();
            this.removeUserStylesheet(this.scene);
        });
    }
}

