/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import javafx.application.Platform;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.display.IDisplay;
import oracle.dbtools.raptor.metrics.viewer.MetricsDisplay;
import oracle.dbtools.raptor.oviewer.xmleditor.XMLBasedEditor;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;

public class MetricsPanelController
implements Controller {
    private boolean acceleratorsSetup;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        String string;
        MetricsDisplay metricsDisplay = this.findDisplay();
        if (metricsDisplay != null && (string = Ide.findCmdName((int)ideAction.getCommandId())) != null) {
            switch (string) {
                case "Metrics.MOUSE_PAN_ZOOM": {
                    this.toggleMousePanZoom(metricsDisplay);
                    return true;
                }
                case "Metrics.ZOOM_IN": {
                    this.zoomIn(metricsDisplay);
                    return true;
                }
                case "Metrics.ZOOM_OUT": {
                    this.zoomOut(metricsDisplay);
                    return true;
                }
                case "Metrics.ZOOM_TO_FIT": {
                    this.zoomToFit(metricsDisplay);
                    return true;
                }
                case "Metrics.ZOOM_ACTUAL": {
                    this.zoomActual(metricsDisplay);
                    return true;
                }
                case "Metrics.PAN_LEFT": {
                    this.panLeft(metricsDisplay);
                    return true;
                }
                case "Metrics.PAN_RIGHT": {
                    this.panRight(metricsDisplay);
                    return true;
                }
                case "Metrics.PAN_UP": {
                    this.panUp(metricsDisplay);
                    return true;
                }
                case "Metrics.PAN_DOWN": {
                    this.panDown(metricsDisplay);
                    return true;
                }
                case "Metrics.SAVE_SNAPSHOT": {
                    this.saveSnapshot(metricsDisplay);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        MetricsDisplay metricsDisplay = this.findDisplay();
        if (metricsDisplay != null) {
            String string;
            if (!this.acceleratorsSetup) {
                this.setupAccelerators(metricsDisplay.getUI(), metricsDisplay.getToolbar());
                this.acceleratorsSetup = true;
            }
            if ((string = Ide.findCmdName((int)ideAction.getCommandId())) != null) {
                switch (string) {
                    case "Metrics.MOUSE_PAN_ZOOM": 
                    case "Metrics.ZOOM_IN": 
                    case "Metrics.ZOOM_OUT": 
                    case "Metrics.ZOOM_TO_FIT": 
                    case "Metrics.ZOOM_ACTUAL": 
                    case "Metrics.PAN_LEFT": 
                    case "Metrics.PAN_RIGHT": 
                    case "Metrics.PAN_UP": 
                    case "Metrics.PAN_DOWN": 
                    case "Metrics.SAVE_SNAPSHOT": {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void setupAccelerators(JComponent jComponent, Toolbar toolbar) {
        try {
            InputMap inputMap = jComponent.getInputMap(1);
            KeyStroke keyStroke = KeyStroke.getKeyStroke(80, 192, false);
            Object object = inputMap.get(keyStroke);
            InputMap inputMap2 = new InputMap();
            inputMap2.put(keyStroke, object);
            UIUtils.addIdeKeyBindings((JComponent)jComponent, (int)1, (String)"oracle/dbtools/raptor/metrics/viewer/accelerators.xml", (InputMap)inputMap2);
            UIUtils.setupAccelerators((Toolbar)toolbar, (String)"oracle/dbtools/raptor/metrics/viewer/accelerators.xml");
        }
        catch (Exception exception) {
            Logger.warn(this.getClass(), (Throwable)exception);
        }
    }

    private MetricsDisplay findDisplay() {
        IDisplay iDisplay;
        MetricsDisplay metricsDisplay = null;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor instanceof XMLBasedEditor && (iDisplay = ((XMLBasedEditor)editor).getMainUI()) instanceof MetricsDisplay) {
            metricsDisplay = (MetricsDisplay)iDisplay;
        }
        return metricsDisplay;
    }

    private void panUp(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.panUp());
    }

    private void panDown(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.panDown());
    }

    private void panLeft(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.panLeft());
    }

    private void panRight(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.panRight());
    }

    private void toggleMousePanZoom(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.toggleMousePanZoom());
    }

    private void zoomIn(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.zoomIn());
    }

    private void zoomOut(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.zoomOut());
    }

    private void zoomToFit(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.zoomToFit());
    }

    private void zoomActual(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.zoomActual());
    }

    private void saveSnapshot(MetricsDisplay metricsDisplay) {
        Platform.runLater(() -> metricsDisplay.saveSnapshot());
    }
}

