/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javax.imageio.ImageIO;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.panel.ContextObjectVisitor;
import oracle.dbtools.raptor.metrics.panel.MetricsPanel;
import oracle.dbtools.raptor.metrics.panel.MetricsPanelManager;
import oracle.dbtools.raptor.metrics.viewer.AbstractPanelAdapter;

public class MetricsPanelAdapter
extends AbstractPanelAdapter {
    private volatile JFXPanel fxPanel;
    private MetricsPanel metricsPanel;
    private MetricsPanelManager panelManager;
    private Scene scene;
    private boolean built = false;
    private final ClassLoader classLoader;
    private final String fxml;
    private final String bundle;
    private final String css;
    private final String contextObjectVisitorClassName;
    private final String connectionName;
    private final double scale;
    private final boolean sizedToFit;

    public MetricsPanelAdapter(ClassLoader classLoader, String string, String string2, String string3, String string4, String string5, double d, boolean bl) {
        super(new BorderLayout());
        this.classLoader = classLoader;
        this.fxml = string;
        this.bundle = string2;
        this.css = string3;
        this.contextObjectVisitorClassName = string4;
        this.connectionName = string5;
        this.scale = d;
        this.sizedToFit = bl;
    }

    public void panLeft() {
        this.panelManager.panLeft();
    }

    public void panRight() {
        this.panelManager.panRight();
    }

    public void panUp() {
        this.panelManager.panUp();
    }

    public void panDown() {
        this.panelManager.panDown();
    }

    public void toggleMousePanZoom() {
        this.panelManager.toggleMousePanZoom();
    }

    public void zoomIn() {
        this.panelManager.zoomIn();
    }

    public void zoomOut() {
        this.panelManager.zoomOut();
    }

    public void zoomActual() {
        this.panelManager.zoomActual();
    }

    public void zoomToFit() {
        this.panelManager.zoomToSize(this.getWidth(), this.getHeight());
    }

    public void saveSnapshot() {
        WritableImage writableImage = new WritableImage((int)this.scene.getWidth(), (int)this.scene.getHeight());
        this.scene.snapshot(writableImage);
        String[] stringArray = ImageIO.getWriterFormatNames();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        StringBuilder stringBuilder = new StringBuilder();
        FileChooser fileChooser = new FileChooser();
        this.appendFormatName(fileChooser, stringBuilder, hashSet, "png");
        this.appendFormatName(fileChooser, stringBuilder, hashSet, "jpg");
        this.appendFormatName(fileChooser, stringBuilder, hashSet, "gif");
        fileChooser.setTitle(MetricsResources.getString("METRICS_SAVE_IMAGE_TITLE"));
        if (stringBuilder.length() > 0) {
            fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(MetricsResources.getString("METRICS_IMAGE_FILES_FILTER_NAME"), new String[]{stringBuilder.toString()}));
        }
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(MetricsResources.getString("METRICS_ALL_FILES_FILTER_NAME"), new String[]{"*.*"}));
        File file = fileChooser.showSaveDialog(this.scene.getWindow());
        if (file != null) {
            String string = file.getName();
            int n = string.lastIndexOf(".");
            String string2 = n < 0 || n >= string.length() - 1 ? "png" : string.substring(n + 1);
            boolean bl = false;
            try {
                bl = ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)writableImage, null), string2, file);
            }
            catch (IOException iOException) {
                Logger.getLogger(MetricsPanelManager.class.getName()).log(Level.SEVERE, null, iOException);
            }
            if (bl) {
                this.showMessageDialog(Alert.AlertType.INFORMATION, MetricsResources.getString("METRICS_SAVE_IMAGE_SUCCESS_TITLE"), MetricsResources.getString("METRICS_SAVE_IMAGE_SUCCESS_HEADER"), MetricsResources.format("METRICS_SAVE_IMAGE_SUCCESS_CONTENT", file.getAbsolutePath()));
            } else {
                this.showMessageDialog(Alert.AlertType.ERROR, MetricsResources.getString("METRICS_SAVE_IMAGE_ERROR_TITLE"), MetricsResources.getString("METRICS_SAVE_IMAGE_ERROR_HEADER"), MetricsResources.getString("METRICS_SAVE_IMAGE_ERROR_CONTENT"));
            }
        }
    }

    public void open(Map<String, Object> map) {
        if (!this.built) {
            this.built = true;
            this.fxPanel = new JFXPanel();
            this.add((Component)this.fxPanel, "Center");
            CountDownLatch countDownLatch = new CountDownLatch(1);
            Platform.runLater(() -> {
                try {
                    this.createFXUI(map);
                    countDownLatch.countDown();
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(MetricsPanelAdapter.class.getName()).log(Level.SEVERE, "error creating FX viewer UI", runtimeException);
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(MetricsPanelAdapter.class.getName()).log(Level.SEVERE, "swing thread interrupted waiting for fx initialization");
            }
        }
    }

    public void close() {
        Platform.runLater(() -> this.closeFXUI());
        if (this.getParent() != null) {
            this.getParent().remove(this);
        }
    }

    private void createFXUI(Map<String, Object> map) {
        this.metricsPanel = MetricsPanel.newBuilder(this.classLoader, this.fxml).bundleBaseName(this.bundle).css(this.css).parameters(map).connectionName(this.connectionName).contextObjectVisitors(this.createContextObjectVisitors()).build();
        this.metricsPanel.backgroundProperty().addListener((ChangeListener)new ChangeListener<Background>(){

            public void changed(ObservableValue<? extends Background> observableValue, Background background, Background background2) {
                block0: {
                    Iterator iterator;
                    if (MetricsPanelAdapter.this.scene == null || background2 == null || !(iterator = background2.getFills().iterator()).hasNext()) break block0;
                    BackgroundFill backgroundFill = (BackgroundFill)iterator.next();
                    MetricsPanelAdapter.this.scene.setFill(backgroundFill.getFill());
                    MetricsPanelAdapter.this.metricsPanel.backgroundProperty().removeListener((ChangeListener)this);
                }
            }
        });
        if (this.sizedToFit) {
            this.scene = new Scene((Parent)this.metricsPanel);
        } else {
            this.panelManager = new MetricsPanelManager(this.metricsPanel, this.scale);
            this.scene = new Scene((Parent)this.panelManager.getScrollPane());
        }
        String string = this.metricsPanel.getPathResolver().process(this.css);
        String string2 = this.classLoader.getResource(string).toExternalForm();
        this.scene.getStylesheets().add((Object)string2);
        this.addUserStylesheet(this.scene);
        this.fxPanel.setScene(this.scene);
        this.metricsPanel.start();
    }

    private void closeFXUI() {
        this.metricsPanel.close();
        this.removeUserStylesheet(this.scene);
    }

    private ContextObjectVisitor[] createContextObjectVisitors() {
        ContextObjectVisitor[] contextObjectVisitorArray = new ContextObjectVisitor[]{};
        if (this.contextObjectVisitorClassName != null && !this.contextObjectVisitorClassName.isEmpty()) {
            try {
                Class<?> clazz = Class.forName(this.contextObjectVisitorClassName, true, this.classLoader);
                contextObjectVisitorArray = new ContextObjectVisitor[]{(ContextObjectVisitor)clazz.newInstance()};
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error instantiating visitor '" + this.contextObjectVisitorClassName + "'", reflectiveOperationException);
            }
        }
        return contextObjectVisitorArray;
    }

    private void appendFormatName(FileChooser fileChooser, StringBuilder stringBuilder, Set<String> set, String string) {
        if (set.contains(string) || set.contains(string.toUpperCase())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("*.");
            stringBuilder.append(string);
            if (fileChooser.getInitialFileName() == null) {
                if (set.contains(string)) {
                    fileChooser.setInitialFileName("*." + string);
                } else if (set.contains(string.toUpperCase())) {
                    fileChooser.setInitialFileName("*." + string.toUpperCase());
                }
            }
        }
    }

    private void showMessageDialog(Alert.AlertType alertType, String string, String string2, String string3) {
        Alert alert = new Alert(alertType);
        alert.initOwner(this.scene.getWindow());
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.setTitle(string);
        alert.setHeaderText(string2);
        alert.setContentText(string3);
        alert.showAndWait();
    }
}

