/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import oracle.dbtools.raptor.metrics.panel.AbstractContent;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;

public class TabPaneMonitor
extends AbstractMonitorObject {
    private final BooleanProperty stopOnDeselectProperty = new SimpleBooleanProperty((Object)this, "stopOnDeselect", false);
    private ChangeListener<Tab> selectionListener;

    public boolean isStopOnDeselect() {
        return this.stopOnDeselectProperty.get();
    }

    public void setStopOnDeselect(boolean bl) {
        this.stopOnDeselectProperty.set(bl);
    }

    public BooleanProperty stopOnDeselectProperty() {
        return this.stopOnDeselectProperty;
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return TabPane.class;
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        TabPane tabPane = context.getContainer(TabPane.class);
        for (Tab tab : tabPane.getTabs()) {
            AbstractContent abstractContent = context.getFacet(AbstractContent.class, (Map<Object, Object>)tab.getProperties());
            if (abstractContent == null) continue;
            consumer.accept(Collections.singletonList(abstractContent));
        }
    }

    @Override
    protected void onInit(Context context) {
        this.selectionListener = (observableValue, tab, tab2) -> {
            AbstractContent abstractContent;
            if (this.isStopOnDeselect() && tab != null && (abstractContent = context.getFacet(AbstractContent.class, (Map<Object, Object>)tab.getProperties())) != null) {
                abstractContent.onHide();
            }
            if (tab2 != null && (abstractContent = context.getFacet(AbstractContent.class, (Map<Object, Object>)tab2.getProperties())) != null && tab2.getContent() == null) {
                tab2.setContent(abstractContent.getContentPanel());
                abstractContent.onShow();
            }
        };
        TabPane tabPane = context.getContainer(TabPane.class);
        SingleSelectionModel singleSelectionModel = tabPane.getSelectionModel();
        singleSelectionModel.selectedItemProperty().addListener(this.selectionListener);
        singleSelectionModel.clearSelection();
        singleSelectionModel.selectFirst();
    }

    @Override
    protected void onClose(Context context) {
        AbstractContent abstractContent;
        TabPane tabPane = context.getContainer(TabPane.class);
        SingleSelectionModel singleSelectionModel = tabPane.getSelectionModel();
        singleSelectionModel.selectedItemProperty().removeListener(this.selectionListener);
        Tab tab = (Tab)singleSelectionModel.getSelectedItem();
        if (tab != null && (abstractContent = context.getFacet(AbstractContent.class, (Map<Object, Object>)tab.getProperties())) != null) {
            abstractContent.onHide();
        }
        singleSelectionModel.clearSelection();
    }
}

