/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.DefaultProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.SplitPane;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

@DefaultProperty(value="panelFactories")
public class SplitPaneMonitor
extends AbstractMonitorObject {
    private final ObservableList<PanelFactory> panelFactories = FXCollections.observableArrayList();
    private final List<PanelFactory.Instance> instances = new ArrayList<PanelFactory.Instance>();

    public ObservableList<PanelFactory> getPanelFactories() {
        return this.panelFactories;
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return SplitPane.class;
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        consumer.accept((List<? extends AbstractContextObject>)this.getPanelFactories());
    }

    @Override
    protected void onInit(Context context) {
        SplitPane splitPane = context.getContainer(SplitPane.class);
        ArrayList arrayList = new ArrayList(this.instances.size());
        for (PanelFactory panelFactory : this.getPanelFactories()) {
            PanelFactory.Instance instance = panelFactory.createPanel();
            this.instances.add(instance);
            arrayList.add(instance.getPanel());
        }
        splitPane.getItems().setAll(arrayList);
    }

    @Override
    protected void onStart(Context context) {
        for (PanelFactory.Instance instance : this.instances) {
            instance.start();
        }
    }

    @Override
    protected void onStop(Context context) {
        for (PanelFactory.Instance instance : this.instances) {
            instance.stop();
        }
    }
}

