/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.Scene;
import javax.ide.util.MetaResource;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.Frame;
import oracle.dbtools.raptor.metrics.dataobject.MarkerValues;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.engine.DXService;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractController;
import oracle.dbtools.raptor.metrics.panel.AbstractNonfacetObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.ContextFactory;
import oracle.dbtools.raptor.metrics.panel.ContextObjectVisitor;
import oracle.dbtools.raptor.metrics.panel.FXMLHelper;
import oracle.dbtools.raptor.metrics.panel.PanelScanner;
import oracle.dbtools.raptor.metrics.panel.PathResolver;

public class PanelFactory<T extends Node>
extends AbstractNonfacetObject {
    private final StringProperty fxmlProperty = new SimpleStringProperty((Object)this, "fxml");
    private final StringProperty connectionKeyProperty = new SimpleStringProperty((Object)this, "connectionKey");
    private final BooleanProperty inheritControllerProperty = new SimpleBooleanProperty((Object)this, "inheritController");
    private final Frame parameters = new Frame();
    private PathResolver pathResolver;
    private Object parentPanelController;
    private String defaultConnectionName;
    private Map<String, String> connectionNameMap;
    private ClassLoader classLoader;
    private String bundleBaseName;
    private String css;
    private URL fxmlURL;
    private List<ContextObjectVisitor> contextObjectVisitors;

    public String getFxml() {
        return (String)this.fxmlProperty.get();
    }

    public void setFxml(String string) {
        this.fxmlProperty.set((Object)string);
    }

    public StringProperty fxmlProperty() {
        return this.fxmlProperty;
    }

    public String getConnectionKey() {
        return (String)this.connectionKeyProperty.get();
    }

    public void setConnectionKey(String string) {
        this.connectionKeyProperty.set((Object)string);
    }

    public StringProperty connectionKeyProperty() {
        return this.connectionKeyProperty;
    }

    public boolean isInheritController() {
        return this.inheritControllerProperty.get();
    }

    public void setInheritController(boolean bl) {
        this.inheritControllerProperty.set(bl);
    }

    public BooleanProperty inheritControllerProperty() {
        return this.inheritControllerProperty;
    }

    public ObservableMap<String, Object> getParameters() {
        return this.parameters.get();
    }

    public Instance createPanel() {
        return this.createPanel(null);
    }

    public Instance createPanel(MarkerValues markerValues) {
        FXMLHelper fXMLHelper;
        Object t;
        Instance instance = null;
        String string = this.pathResolver.process(this.getFxml());
        MetaResource metaResource = new MetaResource(this.classLoader, string);
        this.fxmlURL = metaResource.toURL();
        this.parameters.setMarkerValues(markerValues);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String object2 : this.parameters.getNames()) {
            hashMap.put(object2, this.parameters.getValue(object2));
        }
        Object object3 = null;
        if (this.bundleBaseName != null) {
            object3 = this.pathResolver.process(this.bundleBaseName);
        }
        if ((t = (fXMLHelper = new FXMLHelper(this.classLoader, string, this.parentPanelController, this.isInheritController(), (String)object3, this.defaultConnectionName, hashMap)).getPanel()) != null) {
            instance = new Instance(this, (Node)t, fXMLHelper.getController(), fXMLHelper.getNamespace());
        }
        return instance;
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return Node.class;
    }

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return PanelFactory.class;
    }

    @Override
    protected void onInit(Context context) {
        this.pathResolver = context.getPathResolver();
        this.parentPanelController = context.getPanelController();
        this.classLoader = context.getClassLoader();
        this.bundleBaseName = context.getBundleBaseName();
        this.css = context.getCss();
        this.contextObjectVisitors = context.getContextObjectVisitors();
        this.connectionNameMap = context.getConnectionNameMap();
        String string = this.getConnectionKey();
        if (string != null && !string.isEmpty()) {
            this.defaultConnectionName = this.connectionNameMap.get(string);
            if (this.defaultConnectionName == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "connection name with key ''{0}'' not found", string);
                this.defaultConnectionName = context.getConnectionName();
            }
        } else {
            this.defaultConnectionName = context.getConnectionName();
        }
    }

    void initRootFactory(PathResolver pathResolver, ClassLoader classLoader, String string, String string2, String string3, Map<String, String> map, List<ContextObjectVisitor> list) {
        this.pathResolver = pathResolver;
        this.defaultConnectionName = string3;
        this.connectionNameMap = map;
        this.classLoader = classLoader;
        this.bundleBaseName = string;
        this.css = string2;
        this.contextObjectVisitors = list;
    }

    private void initializePanel(Instance instance, final List<ContextObjectVisitor> list) {
        Object object;
        Object t = instance.getPanel();
        ContextFactory contextFactory = this.createContextFactory(instance);
        PanelScanner panelScanner = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                return PanelFactory.this.getInstance(node) == null;
            }

            @Override
            void process(Context context, List<? extends AbstractContextObject> list) {
                PanelFactory.this.checkContextObjects(context, list);
                super.process(context, list);
            }

            @Override
            void process(Context context, AbstractContextObject abstractContextObject) {
                abstractContextObject.onLoad(context);
            }
        };
        panelScanner.scan((Node)t);
        PanelScanner panelScanner2 = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                return PanelFactory.this.getInstance(node) == null;
            }

            @Override
            void process(Context context, AbstractContextObject abstractContextObject) {
                List<DataObject> list = abstractContextObject.getDataObjects(context);
                if (list != null) {
                    for (DataObject dataObject : list) {
                        dataObject.initialize();
                    }
                }
            }
        };
        panelScanner2.scan((Node)t);
        PanelScanner panelScanner3 = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                return PanelFactory.this.getInstance(node) == null;
            }

            @Override
            void process(Context context, AbstractContextObject abstractContextObject) {
                abstractContextObject.onInit(context);
            }
        };
        panelScanner3.scan((Node)t);
        if (list != null) {
            object = new PanelScanner(contextFactory){

                @Override
                boolean scanInto(Node node) {
                    return PanelFactory.this.getInstance(node) == null;
                }

                @Override
                void process(Context context, AbstractContextObject abstractContextObject) {
                    for (ContextObjectVisitor contextObjectVisitor : list) {
                        contextObjectVisitor.visit(context, abstractContextObject);
                    }
                }
            };
            ((PanelScanner)object).scan((Node)t);
        }
        if ((object = instance.getController(AbstractController.class)) != null) {
            ((AbstractController)object).onSetContext(this.fxmlURL, contextFactory.createContext((Node)t));
        }
    }

    private void startPanel(Instance instance) {
        Object t = instance.getPanel();
        ContextFactory contextFactory = this.createContextFactory(instance);
        PanelScanner panelScanner = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                return PanelFactory.this.getInstance(node) == null;
            }

            @Override
            void process(Context context, AbstractContextObject abstractContextObject) {
                abstractContextObject.onStart(context);
            }
        };
        panelScanner.scan((Node)t);
        final DXListenerList dXListenerList = new DXListenerList();
        PanelScanner panelScanner2 = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                return PanelFactory.this.getInstance(node) == null;
            }

            @Override
            void process(Context context, AbstractContextObject abstractContextObject) {
                List<DataObject> list = abstractContextObject.getDataObjects(context);
                if (list != null) {
                    for (DataObject dataObject : list) {
                        dataObject.registerListener(PanelFactory.this.defaultConnectionName, dXListenerList);
                    }
                }
            }
        };
        panelScanner2.scan((Node)t);
        DXService.registerListeners(dXListenerList);
        AbstractController abstractController = instance.getController(AbstractController.class);
        if (abstractController != null) {
            abstractController.onStart(this.fxmlURL);
        }
        PanelScanner panelScanner3 = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                Instance instance = PanelFactory.this.getInstance(node);
                if (instance != null) {
                    instance.start();
                    return false;
                }
                return true;
            }
        };
        panelScanner3.scan((Node)t);
    }

    private void stopPanel(Instance instance) {
        AbstractController abstractController = instance.getController(AbstractController.class);
        if (abstractController != null) {
            abstractController.onStop(this.fxmlURL);
        }
        Object t = instance.getPanel();
        ContextFactory contextFactory = this.createContextFactory(instance);
        PanelScanner panelScanner = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                Instance instance = PanelFactory.this.getInstance(node);
                if (instance != null) {
                    instance.stop();
                    return false;
                }
                return true;
            }
        };
        panelScanner.scan((Node)t);
        PanelScanner panelScanner2 = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                return PanelFactory.this.getInstance(node) == null;
            }

            @Override
            void process(Context context, AbstractContextObject abstractContextObject) {
                abstractContextObject.onStop(context);
            }
        };
        panelScanner2.scan((Node)t);
        final DXListenerList dXListenerList = new DXListenerList();
        PanelScanner panelScanner3 = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                return PanelFactory.this.getInstance(node) == null;
            }

            @Override
            void process(Context context, AbstractContextObject abstractContextObject) {
                List<DataObject> list = abstractContextObject.getDataObjects(context);
                if (list != null) {
                    for (DataObject dataObject : list) {
                        dataObject.unregisterListener(dXListenerList);
                    }
                }
            }
        };
        panelScanner3.scan((Node)t);
        DXService.unregisterListeners(dXListenerList);
    }

    private void closePanel(Instance instance) {
        Object t = instance.getPanel();
        ContextFactory contextFactory = this.createContextFactory(instance);
        PanelScanner panelScanner = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                Instance instance = PanelFactory.this.getInstance(node);
                if (instance != null) {
                    instance.close();
                    return false;
                }
                return true;
            }
        };
        panelScanner.scan((Node)t);
        PanelScanner panelScanner2 = new PanelScanner(contextFactory){

            @Override
            boolean scanInto(Node node) {
                return PanelFactory.this.getInstance(node) == null;
            }

            @Override
            void process(Context context, AbstractContextObject abstractContextObject) {
                abstractContextObject.onClose(context);
            }
        };
        panelScanner2.scan((Node)t);
    }

    private void checkContextObjects(Context context, List<? extends AbstractContextObject> list) {
        Class<?> clazz = context.getContainer().getClass();
        HashMap<Class<? extends AbstractContextObject>, Integer> hashMap = new HashMap<Class<? extends AbstractContextObject>, Integer>();
        for (AbstractContextObject abstractContextObject : list) {
            Integer n;
            int n2;
            Class<? extends AbstractContextObject> clazz2 = abstractContextObject.getBindAsClass();
            int n3 = abstractContextObject.getBindCardinality();
            boolean bl = false;
            Class<? extends Node> clazz3 = abstractContextObject.getBindToClass();
            if (clazz3.isAssignableFrom(clazz) && (n2 = (n = (Integer)hashMap.get(clazz2)) != null ? n + 1 : 1) <= n3) {
                hashMap.put(clazz2, n2);
                bl = true;
            }
            if (bl) continue;
            throw new IllegalArgumentException("invalid binding of '" + abstractContextObject.getClass().getSimpleName() + "' to '" + clazz.getSimpleName() + "'");
        }
    }

    private Instance getInstance(Node node) {
        return (Instance)node.getProperties().get(PanelFactory.class);
    }

    private ContextFactory createContextFactory(final Instance instance) {
        return new ContextFactory(){

            @Override
            protected Context createContext(final Node node) {
                return new Context(){

                    @Override
                    public Node getContainer() {
                        return node;
                    }

                    @Override
                    public PathResolver getPathResolver() {
                        return PanelFactory.this.pathResolver;
                    }

                    @Override
                    public Map<String, Object> getNamespace() {
                        return instance.getNamespace();
                    }

                    @Override
                    public String getConnectionName() {
                        return PanelFactory.this.defaultConnectionName;
                    }

                    @Override
                    public Map<String, String> getConnectionNameMap() {
                        return PanelFactory.this.connectionNameMap;
                    }

                    @Override
                    public ClassLoader getClassLoader() {
                        return PanelFactory.this.classLoader;
                    }

                    @Override
                    public String getBundleBaseName() {
                        return PanelFactory.this.bundleBaseName;
                    }

                    @Override
                    public String getCss() {
                        return PanelFactory.this.css;
                    }

                    @Override
                    public <T> T getPanelController() {
                        return (T)instance.getController();
                    }

                    @Override
                    public <T> T getParentPanelController() {
                        return (T)PanelFactory.this.parentPanelController;
                    }

                    @Override
                    public List<ContextObjectVisitor> getContextObjectVisitors() {
                        return PanelFactory.this.contextObjectVisitors;
                    }

                    @Override
                    public void requestPanelRestart() {
                        instance.restart();
                    }
                };
            }
        };
    }

    private static enum State {
        CREATED,
        CREATED_START_PENDING,
        STOPPED_START_PENDING,
        RUNNING,
        STOPPED;

    }

    public static class Instance {
        private final T panel;
        private final Object controller;
        private final Map<String, Object> namespace;
        private State state = State.CREATED;
        final /* synthetic */ PanelFactory this$0;

        private Instance(final T t, Object object, Map<String, Object> map) {
            this.this$0 = var1_1;
            this.panel = t;
            this.controller = object;
            this.namespace = map;
            t.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

                public void changed(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                    Instance.this.onSceneSet();
                    t.sceneProperty().removeListener((ChangeListener)this);
                }
            });
        }

        public T getPanel() {
            return this.panel;
        }

        public Object getController() {
            return this.controller;
        }

        public <T> T getController(Class<T> clazz) {
            return (T)(this.controller != null && clazz.isAssignableFrom(this.controller.getClass()) ? this.controller : null);
        }

        public Map<String, Object> getNamespace() {
            return this.namespace;
        }

        public boolean isRunning() {
            switch (this.state) {
                case CREATED_START_PENDING: 
                case STOPPED_START_PENDING: 
                case RUNNING: {
                    return true;
                }
            }
            return false;
        }

        public void start() {
            switch (this.state) {
                case CREATED: {
                    this.state = State.CREATED_START_PENDING;
                    break;
                }
                case STOPPED: {
                    this.deferRun();
                    this.state = State.STOPPED_START_PENDING;
                    break;
                }
            }
        }

        public void stop() {
            switch (this.state) {
                case RUNNING: {
                    this.unrun();
                    this.state = State.STOPPED;
                    break;
                }
                case CREATED_START_PENDING: {
                    this.state = State.CREATED;
                    break;
                }
                case STOPPED_START_PENDING: {
                    this.state = State.STOPPED;
                    break;
                }
            }
        }

        public void restart() {
            switch (this.state) {
                case CREATED: {
                    this.state = State.CREATED_START_PENDING;
                    break;
                }
                case RUNNING: {
                    this.unrun();
                    this.deferRun();
                    this.state = State.STOPPED_START_PENDING;
                    break;
                }
                case STOPPED: {
                    this.deferRun();
                    this.state = State.STOPPED_START_PENDING;
                    break;
                }
            }
        }

        public void close() {
            this.stop();
            this.this$0.closePanel(this);
        }

        private void deferRun() {
            Platform.runLater(() -> this.onDeferredRun());
        }

        private void onSceneSet() {
            this.panel.getProperties().put(PanelFactory.class, (Object)this);
            this.panel.applyCss();
            this.this$0.initializePanel(this, this.this$0.contextObjectVisitors);
            switch (this.state) {
                case CREATED_START_PENDING: {
                    this.run();
                    this.state = State.RUNNING;
                    break;
                }
                case CREATED: {
                    this.state = State.STOPPED;
                    break;
                }
            }
        }

        private void onDeferredRun() {
            switch (this.state) {
                case STOPPED_START_PENDING: {
                    this.run();
                    this.state = State.RUNNING;
                    break;
                }
            }
        }

        private void run() {
            this.this$0.startPanel(this);
        }

        private void unrun() {
            this.this$0.stopPanel(this);
        }
    }
}

