/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import oracle.dbtools.raptor.metrics.dataobject.BooleanDataObject;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

public class OptionMonitor
extends AbstractMonitorObject {
    private final ObjectProperty<BooleanDataObject> selectorProperty = new SimpleObjectProperty((Object)this, "selector");
    private final ObjectProperty<PanelFactory> panelFactoryProperty = new SimpleObjectProperty((Object)this, "panelFactory");
    private final BooleanProperty stopOnDeselectProperty = new SimpleBooleanProperty((Object)this, "stopOnDeselect", false);
    private final StringProperty unselectedTextProperty = new SimpleStringProperty((Object)this, "unselectedText", "");
    private PanelFactory.Instance panelInstance;
    private Label unselectedLabel;

    public BooleanDataObject getSelector() {
        return (BooleanDataObject)this.selectorProperty.get();
    }

    public void setSelector(BooleanDataObject booleanDataObject) {
        this.selectorProperty.set((Object)booleanDataObject);
    }

    public ObjectProperty<BooleanDataObject> selectorProperty() {
        return this.selectorProperty;
    }

    public PanelFactory getPanelFactory() {
        return (PanelFactory)this.panelFactoryProperty.get();
    }

    public void setPanelFactory(PanelFactory panelFactory) {
        this.panelFactoryProperty.set((Object)panelFactory);
    }

    public ObjectProperty<PanelFactory> panelFactoryProperty() {
        return this.panelFactoryProperty;
    }

    public boolean isStopOnDeselect() {
        return this.stopOnDeselectProperty.get();
    }

    public void setStopOnDeselect(boolean bl) {
        this.stopOnDeselectProperty.set(bl);
    }

    public BooleanProperty stopOnDeselectProperty() {
        return this.stopOnDeselectProperty;
    }

    public String getUnselectedText() {
        return (String)this.unselectedTextProperty.get();
    }

    public void setUnselectedText(String string) {
        this.unselectedTextProperty.set((Object)string);
    }

    public StringProperty unselectedTextProperty() {
        return this.unselectedTextProperty;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.getSelector());
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return StackPane.class;
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        consumer.accept(Collections.singletonList(this.getPanelFactory()));
    }

    @Override
    protected void onInit(Context context) {
        PanelFactory panelFactory = this.getPanelFactory();
        this.panelInstance = panelFactory.createPanel();
        Region region = (Region)this.panelInstance.getPanel();
        region.setVisible(false);
        StackPane stackPane = context.getContainer(StackPane.class);
        stackPane.getChildren().add((Object)region);
        this.unselectedLabel = new Label(this.getUnselectedText());
        this.unselectedLabel.getStyleClass().add((Object)"unselected-label");
        this.unselectedLabel.setMaxWidth(Double.MAX_VALUE);
        this.unselectedLabel.setMaxHeight(Double.MAX_VALUE);
        this.unselectedLabel.setAlignment(Pos.CENTER);
        stackPane.getChildren().add((Object)this.unselectedLabel);
        ObservableBooleanValue observableBooleanValue = this.getSelector().getObservable();
        if (observableBooleanValue.get()) {
            ((Region)this.panelInstance.getPanel()).setVisible(true);
            if (!this.panelInstance.isRunning()) {
                this.panelInstance.start();
            }
            this.unselectedLabel.setVisible(false);
        }
        observableBooleanValue.addListener((observableValue, bl, bl2) -> {
            if (!bl2.booleanValue()) {
                ((Region)this.panelInstance.getPanel()).setVisible(false);
                this.unselectedLabel.setVisible(true);
                if (this.isStopOnDeselect() && this.panelInstance.isRunning()) {
                    this.panelInstance.stop();
                }
            } else {
                ((Region)this.panelInstance.getPanel()).setVisible(true);
                this.unselectedLabel.setVisible(false);
                if (!this.panelInstance.isRunning()) {
                    this.panelInstance.start();
                }
            }
        });
    }

    @Override
    protected void onClose(Context context) {
        ((Region)this.panelInstance.getPanel()).setVisible(false);
        if (!this.panelInstance.isRunning()) {
            this.panelInstance.stop();
        }
        this.unselectedLabel.setVisible(true);
    }
}

