/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.util.Callback;
import oracle.dbtools.raptor.metrics.dataobject.AtomicDataObject;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.NameValueTreeCellFactory;
import oracle.dbtools.raptor.metrics.panel.NameValueTreeItemProperties;

public class NameValueTreeTableMonitor
extends AbstractMonitorObject {
    private List<NameValueTreeItemProperties> treeItemProperties;
    private TreeTableColumn<NameValueTreeItemProperties, Object> nameColumn;
    private TreeTableColumn<NameValueTreeItemProperties, Object> valueColumn;

    @Override
    protected Class<? extends Node> getBindToClass() {
        return TreeTableView.class;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        List<NameValueTreeItemProperties> list = this.getCachedTreeItemProperties((TreeTableView<NameValueTreeItemProperties>)context.getContainer(TreeTableView.class));
        for (NameValueTreeItemProperties nameValueTreeItemProperties : list) {
            AtomicDataObject atomicDataObject = nameValueTreeItemProperties.getItem();
            if (atomicDataObject == null) continue;
            arrayList.add(nameValueTreeItemProperties.getItem());
        }
        return arrayList;
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        TreeTableView treeTableView = context.getContainer(TreeTableView.class);
        List<NameValueTreeItemProperties> list = this.getCachedTreeItemProperties((TreeTableView<NameValueTreeItemProperties>)treeTableView);
        consumer.accept(list);
    }

    @Override
    protected void onInit(Context context) {
        TreeTableView treeTableView = context.getContainer(TreeTableView.class);
        ObservableList observableList = treeTableView.getColumns();
        if (observableList.size() > 0) {
            this.nameColumn = (TreeTableColumn)observableList.get(0);
        } else {
            this.nameColumn = new TreeTableColumn("Name");
            observableList.add(this.nameColumn);
        }
        if (observableList.size() > 1) {
            this.valueColumn = (TreeTableColumn)observableList.get(1);
        } else {
            this.valueColumn = new TreeTableColumn("Value");
            observableList.add(this.valueColumn);
        }
        this.nameColumn.setCellValueFactory(cellDataFeatures -> {
            NameValueTreeItemProperties nameValueTreeItemProperties = (NameValueTreeItemProperties)cellDataFeatures.getValue().getValue();
            if (nameValueTreeItemProperties != null) {
                return Bindings.createObjectBinding(() -> nameValueTreeItemProperties.getName(), (Observable[])new Observable[]{nameValueTreeItemProperties.nameProperty()});
            }
            return Bindings.createObjectBinding(() -> "", (Observable[])new Observable[0]);
        });
        this.nameColumn.setCellFactory((Callback)new NameValueTreeCellFactory(context, true));
        this.valueColumn.setCellValueFactory(cellDataFeatures -> {
            ObservableValue observableValue;
            NameValueTreeItemProperties nameValueTreeItemProperties = (NameValueTreeItemProperties)cellDataFeatures.getValue().getValue();
            AtomicDataObject atomicDataObject = nameValueTreeItemProperties.getItem();
            ObservableValue observableValue2 = observableValue = atomicDataObject != null ? atomicDataObject.getObservable() : null;
            if (observableValue != null) {
                return Bindings.createObjectBinding(() -> observableValue.getValue(), (Observable[])new Observable[]{observableValue});
            }
            return Bindings.createObjectBinding(() -> "", (Observable[])new Observable[0]);
        });
        this.valueColumn.setCellFactory((Callback)new NameValueTreeCellFactory(context, false));
    }

    private List<NameValueTreeItemProperties> getCachedTreeItemProperties(TreeTableView<NameValueTreeItemProperties> treeTableView) {
        if (this.treeItemProperties == null) {
            this.treeItemProperties = new ArrayList<NameValueTreeItemProperties>();
            this.cacheTreeItemProperties((TreeItem<NameValueTreeItemProperties>)treeTableView.getRoot());
        }
        return this.treeItemProperties;
    }

    private void cacheTreeItemProperties(TreeItem<NameValueTreeItemProperties> treeItem) {
        NameValueTreeItemProperties nameValueTreeItemProperties = (NameValueTreeItemProperties)treeItem.getValue();
        if (nameValueTreeItemProperties != null) {
            this.treeItemProperties.add(nameValueTreeItemProperties);
        }
        for (TreeItem treeItem2 : treeItem.getChildren()) {
            this.cacheTreeItemProperties((TreeItem<NameValueTreeItemProperties>)treeItem2);
        }
    }
}

