/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.HashMap;
import java.util.Map;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.control.cell.TextFieldTreeTableCell;
import javafx.scene.effect.Effect;
import javafx.scene.effect.MotionBlur;
import javafx.util.Callback;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.dataobject.AtomicDataObject;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractNonfacetObject;
import oracle.dbtools.raptor.metrics.panel.ChangeIndicator;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.NameValueTreeItemProperties;
import oracle.dbtools.raptor.metrics.panel.NameValueTreeTableMonitor;

class NameValueTreeCellFactory
extends AbstractNonfacetObject
implements Callback<TreeTableColumn<NameValueTreeItemProperties, Object>, TreeTableCell<NameValueTreeItemProperties, Object>> {
    private final boolean nameColumn;
    private final Context context;
    private Map<TreeTableCell<NameValueTreeItemProperties, Object>, ChangeEffect> changeMap;
    private boolean changeMapInitialized = false;

    NameValueTreeCellFactory(Context context, boolean bl) {
        this.context = context;
        this.nameColumn = bl;
    }

    public TreeTableCell<NameValueTreeItemProperties, Object> call(TreeTableColumn<NameValueTreeItemProperties, Object> treeTableColumn) {
        final CellHandle cellHandle = new CellHandle();
        TextFieldTreeTableCell textFieldTreeTableCell = new TextFieldTreeTableCell(){

            public void updateItem(Object object, boolean bl) {
                NameValueTreeCellFactory.this.beforeCellUpdate(cellHandle, (TreeTableCell<NameValueTreeItemProperties, Object>)this, bl);
                super.updateItem(object, bl);
            }
        };
        textFieldTreeTableCell.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>((TreeTableCell)textFieldTreeTableCell){
            final /* synthetic */ TreeTableCell val$cell;
            {
                this.val$cell = treeTableCell;
            }

            public void changed(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                this.val$cell.sceneProperty().removeListener((ChangeListener)this);
                NameValueTreeCellFactory.this.ensureChangeMapInitialized((TreeTableCell<NameValueTreeItemProperties, Object>)this.val$cell);
            }
        });
        return textFieldTreeTableCell;
    }

    protected void beforeCellUpdate(CellHandle cellHandle, TreeTableCell<NameValueTreeItemProperties, Object> treeTableCell, boolean bl) {
        if (!bl) {
            int n = treeTableCell.getIndex();
            NameValueTreeItemProperties nameValueTreeItemProperties = (NameValueTreeItemProperties)treeTableCell.getTreeTableView().getTreeItem(n).getValue();
            if (this.nameColumn) {
                treeTableCell.setContextMenu(nameValueTreeItemProperties.getContextMenu());
            } else {
                ObservableValue observableValue;
                AtomicDataObject atomicDataObject;
                Object object = null;
                if (this.changeMap != null && n == cellHandle.indexNo && nameValueTreeItemProperties != null && (atomicDataObject = nameValueTreeItemProperties.getItem()) != null && (observableValue = atomicDataObject.getObservable()) != null && !(object = observableValue.getValue()).equals(cellHandle.value)) {
                    ChangeEffect changeEffect = this.changeMap.get(treeTableCell);
                    if (changeEffect != null) {
                        changeEffect.cancel((TreeTableCell<NameValueTreeItemProperties, Object>)treeTableCell);
                    }
                    changeEffect = new ChangeEffect(treeTableCell);
                    this.changeMap.put(treeTableCell, changeEffect);
                }
                cellHandle.value = object;
            }
            cellHandle.indexNo = n;
        }
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return TreeTableView.class;
    }

    @Override
    protected Class<? extends AbstractContextObject> getBindAsClass() {
        return NameValueTreeCellFactory.class;
    }

    private void ensureChangeMapInitialized(TreeTableCell<NameValueTreeItemProperties, Object> treeTableCell) {
        if (!this.changeMapInitialized) {
            NameValueTreeTableMonitor nameValueTreeTableMonitor = null;
            for (Parent parent = treeTableCell.getParent(); parent != null && nameValueTreeTableMonitor == null; parent = parent.getParent()) {
                nameValueTreeTableMonitor = this.context.getFacet(NameValueTreeTableMonitor.class, (Map<Object, Object>)parent.getProperties());
                if (nameValueTreeTableMonitor == null) continue;
                ChangeIndicator changeIndicator = this.context.getFacet(ChangeIndicator.class, (Map<Object, Object>)parent.getProperties());
                if (changeIndicator == null) break;
                this.changeMap = new HashMap<TreeTableCell<NameValueTreeItemProperties, Object>, ChangeEffect>();
                break;
            }
            this.changeMapInitialized = true;
        }
    }

    private class ChangeEffect {
        private final FadeTransition fadeTransition;

        private ChangeEffect(TreeTableCell<NameValueTreeItemProperties, Object> treeTableCell) {
            this.fadeTransition = new FadeTransition(Duration.seconds((double)0.25), treeTableCell);
            this.fadeTransition.setFromValue(1.0);
            this.fadeTransition.setToValue(0.9);
            this.fadeTransition.setCycleCount(2);
            this.fadeTransition.setAutoReverse(true);
            this.fadeTransition.setOnFinished(actionEvent -> this.cancel(treeTableCell));
            treeTableCell.setEffect((Effect)new MotionBlur(0.0, 10.0));
            this.fadeTransition.play();
        }

        private void cancel(TreeTableCell<NameValueTreeItemProperties, Object> treeTableCell) {
            if (this.fadeTransition.getStatus() == Animation.Status.RUNNING) {
                this.fadeTransition.stop();
            }
            treeTableCell.setEffect(null);
            NameValueTreeCellFactory.this.changeMap.remove(treeTableCell);
        }
    }

    protected class CellHandle {
        private Object value;
        private int indexNo = -1;

        protected CellHandle() {
        }
    }
}

