/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Screen;

public class MetricsPanelManager {
    private final ScrollPane scrollPane;
    private final MetricsPanelGroup group;
    private final Region metricsPanel;
    private final double resetScale;
    private Node scrollPaneViewport;
    private boolean panZoomMode;
    private boolean zooming;
    private double currentZoom;
    private double dragZoomInitial;
    private int dragInitial;
    private int deltaDrag;
    private int deltaDragThreshold;
    private double scale;

    public MetricsPanelManager(Region region, double d) {
        this.metricsPanel = region;
        this.scale = d;
        this.currentZoom = Math.log10(d);
        this.resetScale = d;
        this.group = new MetricsPanelGroup(new Node[]{region});
        this.scrollPane = new ScrollPane((Node)this.group);
        this.applyTransforms();
        this.setupZoomHandlers();
    }

    public ScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void panLeft() {
        double d = this.scrollPane.getHvalue();
        d = d < 0.9 ? (d += 0.1) : 1.0;
        this.scrollPane.setHvalue(d);
    }

    public void panRight() {
        double d = this.scrollPane.getHvalue();
        d = d > 0.1 ? (d -= 0.1) : 0.0;
        this.scrollPane.setHvalue(d);
    }

    public void panUp() {
        double d = this.scrollPane.getVvalue();
        d = d < 0.9 ? (d += 0.1) : 1.0;
        this.scrollPane.setVvalue(d);
    }

    public void panDown() {
        double d = this.scrollPane.getVvalue();
        d = d > 0.1 ? (d -= 0.1) : 0.0;
        this.scrollPane.setVvalue(d);
    }

    public void zoomIn() {
        this.currentZoom += this.getZoomIncrement();
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void zoomOut() {
        this.currentZoom -= this.getZoomIncrement();
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void zoomActual() {
        this.currentZoom = Math.log10(this.resetScale);
        this.scale = this.resetScale;
        this.applyTransforms();
    }

    public void zoomToSize(double d, double d2) {
        this.currentZoom = this.getZoomToSize(this.scrollPane.getWidth(), this.scrollPane.getHeight());
        this.scale = Math.pow(10.0, this.currentZoom);
        this.applyTransforms();
    }

    public void toggleMousePanZoom() {
        this.panZoomMode = !this.panZoomMode;
        this.scrollPane.setPannable(this.panZoomMode);
        this.scrollPane.getContent().setMouseTransparent(this.panZoomMode);
        if (this.scrollPaneViewport == null) {
            this.scrollPaneViewport = this.scrollPane.lookup(".viewport");
        }
        if (this.panZoomMode) {
            this.scrollPaneViewport.setCursor(Cursor.MOVE);
        } else {
            this.scrollPaneViewport.setCursor(Cursor.DEFAULT);
        }
    }

    private void setupZoomHandlers() {
        this.scrollPane.addEventFilter(MouseEvent.DRAG_DETECTED, mouseEvent -> {
            if (this.panZoomMode && mouseEvent.isControlDown()) {
                this.zooming = true;
                this.beginZoom((int)mouseEvent.getScreenX());
                mouseEvent.consume();
            }
        });
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_DRAGGED, mouseEvent -> {
            if (this.panZoomMode && this.zooming) {
                this.zoom((int)mouseEvent.getScreenX());
                mouseEvent.consume();
            }
        });
        this.scrollPane.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> {
            if (this.panZoomMode && this.zooming) {
                this.zooming = false;
                mouseEvent.consume();
            }
        });
    }

    private void applyTransforms() {
        Scale scale = Transform.scale((double)this.scale, (double)this.scale, (double)0.0, (double)0.0);
        this.metricsPanel.getTransforms().setAll((Object[])new Transform[]{scale});
    }

    private void beginZoom(int n) {
        if (this.deltaDragThreshold == 0) {
            this.deltaDragThreshold = (int)Screen.getPrimary().getVisualBounds().getWidth() / 2;
        }
        this.dragInitial = n;
        this.dragZoomInitial = this.currentZoom;
    }

    private void zoom(int n) {
        int n2 = n - this.dragInitial;
        if (n2 != this.deltaDrag) {
            this.deltaDrag = n2;
            this.currentZoom = this.dragZoomInitial + (double)this.deltaDrag / (double)this.deltaDragThreshold;
            this.scale = Math.pow(10.0, this.currentZoom);
            this.applyTransforms();
        }
    }

    private double getZoomToSize(double d, double d2) {
        double d3 = this.metricsPanel.prefWidth(-1.0) + 4.0;
        double d4 = d2 / d;
        double d5 = this.metricsPanel.prefHeight(-1.0) + 4.0;
        double d6 = d5 / d3;
        return Math.log10(d4 > d6 ? d / d3 : d2 / d5);
    }

    private double getZoomIncrement() {
        return 0.05;
    }

    private static class MetricsPanelGroup
    extends Parent {
        MetricsPanelGroup(Node ... nodeArray) {
            this.getChildren().addAll((Object[])nodeArray);
        }
    }
}

