/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javax.ide.util.MetaResource;
import oracle.dbtools.raptor.metrics.panel.AbstractController;

class FXMLHelper<T extends Node> {
    private Object controller;
    private Map<String, Object> namespace;
    private T panel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FXMLHelper(ClassLoader classLoader, String string, Object object, boolean bl, String string2, String string3, Map<String, Object> map) {
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            MetaResource metaResource = new MetaResource(classLoader, string);
            FXMLLoader fXMLLoader = new FXMLLoader(metaResource.toURL());
            this.namespace = fXMLLoader.getNamespace();
            for (String string4 : map.keySet()) {
                this.namespace.put(string4, map.get(string4));
            }
            fXMLLoader.setClassLoader(classLoader);
            if (bl) {
                fXMLLoader.setController(object);
            } else {
                fXMLLoader.setControllerFactory(clazz -> {
                    if (AbstractController.class.isAssignableFrom((Class<?>)clazz)) {
                        if (this.controller != null) {
                            return this.controller;
                        }
                        try {
                            this.controller = clazz.newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                            throw new RuntimeException(reflectiveOperationException);
                        }
                        return this.controller;
                    }
                    try {
                        return clazz.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        throw new RuntimeException(reflectiveOperationException);
                    }
                });
            }
            if (string2 != null) {
                try {
                    ResourceBundle resourceBundle = ResourceBundle.getBundle(string2, Locale.getDefault(), classLoader);
                    fXMLLoader.setResources(resourceBundle);
                }
                catch (MissingResourceException missingResourceException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "resource bundle not found: {0} \n {1}", new Object[]{string2, missingResourceException});
                    throw new IllegalArgumentException("bundleBaseName", missingResourceException);
                }
            }
            try {
                this.panel = (Node)fXMLLoader.load();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "fxml load error: {0}: {1}", new Object[]{string, exception});
                throw new IllegalArgumentException("fxmlURL", exception);
            }
            if (this.controller == null) {
                this.controller = fXMLLoader.getController();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
    }

    Object getController() {
        return this.controller;
    }

    <T> T getController(Class<T> clazz) {
        return (T)(this.controller != null && clazz.isAssignableFrom(this.controller.getClass()) ? this.controller : null);
    }

    Map<String, Object> getNamespace() {
        return this.namespace;
    }

    T getPanel() {
        return this.panel;
    }
}

