/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableColumnBase;
import oracle.dbtools.raptor.metrics.dataobject.BoundList;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractCellFactory;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.VarBinding;

@DefaultProperty(value="item")
public abstract class AbstractTableMonitor<C extends TableColumnBase<?, Object>, L extends IndexedCell<Object>>
extends AbstractMonitorObject {
    private final ObjectProperty<BoundList> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final ObjectProperty<ContextMenu> contextMenuProperty = new SimpleObjectProperty((Object)this, "contextMenu");
    private final ObservableList<VarBinding> varBindings = FXCollections.observableArrayList();

    public BoundList getItem() {
        return (BoundList)this.itemProperty.get();
    }

    public void setItem(BoundList boundList) {
        this.itemProperty.set((Object)boundList);
    }

    public ObjectProperty<BoundList> itemProperty() {
        return this.itemProperty;
    }

    public ObservableList<VarBinding> getVarBindings() {
        return this.varBindings;
    }

    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenuProperty.get();
    }

    public void setContextMenu(ContextMenu contextMenu) {
        this.contextMenuProperty.set((Object)contextMenu);
    }

    public ObjectProperty<ContextMenu> contextMenuProperty() {
        return this.contextMenuProperty;
    }

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.itemProperty.get());
    }

    protected abstract DXRow getRow(L var1);

    protected abstract C getColumn(L var1);

    protected abstract AbstractCellFactory<C, L> getCellFactory(C var1);

    protected void updateSelectedRowValues(DXRow dXRow) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (dXRow != null) {
            for (String string : dXRow.getNames()) {
                hashMap.put(string, dXRow.get(string, Comparable.class).get());
            }
        }
        for (VarBinding varBinding : this.varBindings) {
            varBinding.updateVar(hashMap);
        }
    }
}

