/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;
import oracle.dbtools.raptor.metrics.panel.Selection;

@DefaultProperty(value="selections")
public abstract class AbstractSelectionMonitor
extends AbstractMonitorObject {
    private final ObservableList<Selection> selections = FXCollections.observableArrayList();
    private final BooleanProperty stopOnDeselectProperty = new SimpleBooleanProperty((Object)this, "stopOnDeselect", false);
    private final StringProperty unselectedTextProperty = new SimpleStringProperty((Object)this, "unselectedText", "");
    private final Map<String, PanelFactory.Instance> panelInstanceMap = new HashMap<String, PanelFactory.Instance>();
    private Label unselectedLabel;

    public ObservableList<Selection> getSelections() {
        return this.selections;
    }

    public boolean isStopOnDeselect() {
        return this.stopOnDeselectProperty.get();
    }

    public void setStopOnDeselect(boolean bl) {
        this.stopOnDeselectProperty.set(bl);
    }

    public BooleanProperty stopOnDeselectProperty() {
        return this.stopOnDeselectProperty;
    }

    public String getUnselectedText() {
        return (String)this.unselectedTextProperty.get();
    }

    public void setUnselectedText(String string) {
        this.unselectedTextProperty.set((Object)string);
    }

    public StringProperty unselectedTextProperty() {
        return this.unselectedTextProperty;
    }

    @Override
    protected Class<? extends Node> getBindToClass() {
        return StackPane.class;
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        ArrayList<PanelFactory> arrayList = new ArrayList<PanelFactory>();
        for (Selection selection : this.selections) {
            arrayList.add(selection.getPanelFactory());
        }
        consumer.accept(arrayList);
    }

    @Override
    protected void onInit(Context context) {
        StackPane stackPane = context.getContainer(StackPane.class);
        for (Selection selection : this.selections) {
            String string = selection.getSelector();
            PanelFactory panelFactory = selection.getPanelFactory();
            PanelFactory.Instance instance = panelFactory.createPanel();
            Region region = (Region)instance.getPanel();
            region.setVisible(false);
            stackPane.getChildren().add((Object)region);
            this.panelInstanceMap.put(string, instance);
        }
        this.unselectedLabel = new Label(this.getUnselectedText());
        this.unselectedLabel.getStyleClass().add((Object)"unselected-label");
        this.unselectedLabel.setMaxWidth(Double.MAX_VALUE);
        this.unselectedLabel.setMaxHeight(Double.MAX_VALUE);
        this.unselectedLabel.setAlignment(Pos.CENTER);
        stackPane.getChildren().add((Object)this.unselectedLabel);
    }

    protected void start(String string) {
        PanelFactory.Instance instance;
        boolean bl = false;
        if (string != null && (instance = this.panelInstanceMap.get(string)) != null) {
            bl = true;
            ((Region)instance.getPanel()).setVisible(true);
            if (!instance.isRunning()) {
                instance.start();
            }
        }
        this.unselectedLabel.setVisible(!bl);
    }

    protected void stop(String string) {
        PanelFactory.Instance instance;
        if (string != null && (instance = this.panelInstanceMap.get(string)) != null) {
            ((Region)instance.getPanel()).setVisible(false);
            if (this.isStopOnDeselect() && instance.isRunning()) {
                instance.stop();
            }
        }
        this.unselectedLabel.setVisible(true);
    }
}

