/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.panel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.DefaultProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableListValue;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;
import oracle.dbtools.raptor.metrics.control.AbstractGraphControl;
import oracle.dbtools.raptor.metrics.control.BezierComponent;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.GraphObject;
import oracle.dbtools.raptor.metrics.control.LocatedEdge;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;
import oracle.dbtools.raptor.metrics.dataobject.DataObject;
import oracle.dbtools.raptor.metrics.dataobject.ListDataObject;
import oracle.dbtools.raptor.metrics.dataobject.MarkerValues;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.AbstractContextObject;
import oracle.dbtools.raptor.metrics.panel.AbstractMonitorObject;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.PanelFactory;

@DefaultProperty(value="item")
public abstract class AbstractGraphMonitor<G extends Graph<DXRow, V, E>, V extends LocatedVertex<DXRow, V, E>, E extends LocatedEdge<DXRow, V, E>, ER extends BezierComponent>
extends AbstractMonitorObject {
    private final ObjectProperty<ListDataObject> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final StringProperty vertexIDColumnProperty = new SimpleStringProperty((Object)this, "vertexIDColumn");
    private final StringProperty vertexLabelColumnProperty = new SimpleStringProperty((Object)this, "vertexLabelColumn");
    private final StringProperty destVertexIDColumnProperty = new SimpleStringProperty((Object)this, "destVertexIDColumn");
    private final StringProperty styleClassColumnProperty = new SimpleStringProperty((Object)this, "styleClassColumn");
    private final ObjectProperty<PanelFactory<Region>> vertexRepresentationPanelFactoryProperty = new SimpleObjectProperty((Object)this, "vertexRepresentationPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> vertexDisplayPanelFactoryProperty = new SimpleObjectProperty((Object)this, "vertexDisplayPanelFactory");
    private final ObjectProperty<PanelFactory<Region>> edgeDisplayPanelFactoryProperty = new SimpleObjectProperty((Object)this, "edgeDisplayPanelFactory");
    private ChangeListener<Boolean> listener;

    public ListDataObject getItem() {
        return (ListDataObject)this.itemProperty.get();
    }

    public void setItem(ListDataObject listDataObject) {
        this.itemProperty.set((Object)listDataObject);
    }

    public ObjectProperty<ListDataObject> itemProperty() {
        return this.itemProperty;
    }

    public String getVertexIDColumn() {
        return (String)this.vertexIDColumnProperty.get();
    }

    public void setVertexIDColumn(String string) {
        this.vertexIDColumnProperty.set((Object)string);
    }

    public StringProperty vertexIDColumnProperty() {
        return this.vertexIDColumnProperty;
    }

    public String getVertexLabelColumn() {
        return (String)this.vertexLabelColumnProperty.get();
    }

    public void setVertexLabelColumn(String string) {
        this.vertexLabelColumnProperty.set((Object)string);
    }

    public StringProperty vertexLabelColumnProperty() {
        return this.vertexLabelColumnProperty;
    }

    public String getDestVertexIDColumn() {
        return (String)this.destVertexIDColumnProperty.get();
    }

    public void setDestVertexIDColumn(String string) {
        this.destVertexIDColumnProperty.set((Object)string);
    }

    public StringProperty destVertexIDColumnProperty() {
        return this.destVertexIDColumnProperty;
    }

    public String getStyleClassColumn() {
        return (String)this.styleClassColumnProperty.get();
    }

    public void setStyleClassColumn(String string) {
        this.styleClassColumnProperty.set((Object)string);
    }

    public StringProperty styleClassColumnProperty() {
        return this.styleClassColumnProperty;
    }

    public PanelFactory<Region> getVertexRepresentationPanelFactory() {
        return (PanelFactory)this.vertexRepresentationPanelFactoryProperty.get();
    }

    public void setVertexRepresentationPanelFactory(PanelFactory<Region> panelFactory) {
        this.vertexRepresentationPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> vertexRepresentationPanelFactoryProperty() {
        return this.vertexRepresentationPanelFactoryProperty;
    }

    public PanelFactory<Region> getVertexDisplayPanelFactory() {
        return (PanelFactory)this.vertexDisplayPanelFactoryProperty.get();
    }

    public void setVertexDisplayPanelFactory(PanelFactory<Region> panelFactory) {
        this.vertexDisplayPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> vertexDisplayPanelFactoryProperty() {
        return this.vertexDisplayPanelFactoryProperty;
    }

    public PanelFactory<Region> getEdgeDisplayPanelFactory() {
        return (PanelFactory)this.edgeDisplayPanelFactoryProperty.get();
    }

    public void setEdgeDisplayPanelFactory(PanelFactory<Region> panelFactory) {
        this.edgeDisplayPanelFactoryProperty.set(panelFactory);
    }

    public ObjectProperty<PanelFactory<Region>> edgeDisplayPanelFactoryProperty() {
        return this.edgeDisplayPanelFactoryProperty;
    }

    protected abstract V createVertex(DXRow var1);

    protected abstract E createEdge(V var1, V var2, DXRow var3);

    @Override
    protected List<DataObject> getDataObjects(Context context) {
        return Collections.singletonList(this.itemProperty.get());
    }

    @Override
    protected void scanRelated(Context context, Consumer<List<? extends AbstractContextObject>> consumer) {
        PanelFactory<Region> panelFactory;
        PanelFactory<Region> panelFactory2;
        PanelFactory<Region> panelFactory3 = this.getVertexRepresentationPanelFactory();
        if (panelFactory3 != null) {
            consumer.accept(Collections.singletonList(panelFactory3));
        }
        if ((panelFactory2 = this.getVertexDisplayPanelFactory()) != null) {
            consumer.accept(Collections.singletonList(panelFactory2));
        }
        if ((panelFactory = this.getEdgeDisplayPanelFactory()) != null) {
            consumer.accept(Collections.singletonList(panelFactory));
        }
    }

    @Override
    protected void onInit(Context context) {
        if (this.listener == null) {
            PanelFactory<Region> panelFactory;
            PanelFactory<Region> panelFactory2;
            AbstractGraphControl abstractGraphControl = context.getContainer(AbstractGraphControl.class);
            PanelFactory<Region> panelFactory3 = this.getVertexRepresentationPanelFactory();
            if (panelFactory3 != null) {
                abstractGraphControl.setVertexRepresentationFactory(locatedVertex -> this.createPanel(panelFactory3, (DXRow)locatedVertex.getValue(), locatedVertex.getStyleClass()));
            }
            if ((panelFactory2 = this.getVertexDisplayPanelFactory()) != null) {
                abstractGraphControl.setVertexDisplayFactory(locatedVertex -> this.createPanel(panelFactory2, (DXRow)locatedVertex.getValue(), locatedVertex.getStyleClass()));
            }
            if ((panelFactory = this.getEdgeDisplayPanelFactory()) != null) {
                abstractGraphControl.setEdgeDisplayFactory(locatedEdge -> this.createPanel(panelFactory, (DXRow)locatedEdge.getValue(), locatedEdge.getStyleClass()));
            }
            this.listener = (observableValue, bl, bl2) -> {
                if (!bl2.booleanValue()) {
                    Platform.runLater(() -> this.resetModel(abstractGraphControl));
                }
            };
            this.getItem().getUpdating().addListener(this.listener);
        }
    }

    @Override
    protected void onClose(Context context) {
        if (this.listener != null) {
            this.getItem().getUpdating().removeListener(this.listener);
            this.listener = null;
        }
    }

    protected void resetModel(AbstractGraphControl<DXRow, G, V, E, ER> abstractGraphControl) {
        Object object;
        HashMap hashMap;
        Object object22;
        Object object3;
        ObservableListValue<DXRow> observableListValue;
        Object object42;
        String string = this.getVertexIDColumn();
        String string2 = this.getVertexLabelColumn();
        if (string2 == null) {
            string2 = string;
        }
        String string3 = this.getDestVertexIDColumn();
        ObservableList observableList = ((Graph)abstractGraphControl.getGraph()).getVertices();
        HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
        for (Object object42 : observableList) {
            observableListValue = (DXRow)((GraphObject)object42).getValue();
            Iterator iterator = (String)observableListValue.get(string, String.class).get();
            hashMap2.put(iterator, object42);
        }
        ObservableList observableList2 = ((Graph)abstractGraphControl.getGraph()).getEdges();
        object42 = new HashMap();
        for (Iterator iterator : observableList2) {
            Object object5 = (DXRow)((GraphObject)((Object)iterator)).getValue();
            object3 = (String)object5.get(string, String.class).get();
            object22 = (String)object5.get(string3, String.class).get();
            hashMap = (HashMap)object42.get(object3);
            if (hashMap == null) {
                hashMap = new HashMap();
                object42.put(object3, hashMap);
            }
            hashMap.put((String)object22, iterator);
        }
        observableListValue = this.getItem().getObservable();
        for (Object object5 : observableListValue) {
            object3 = (String)object5.get("Type", String.class).get();
            if (!((String)object3).equals("VERTEX") || (hashMap = (LocatedVertex)hashMap2.get(object22 = (String)object5.get(string, String.class).get())) != null) continue;
            hashMap = this.createVertex((DXRow)object5);
            ((GraphObject)((Object)hashMap)).setValue(object5);
            ((LocatedVertex)((Object)hashMap)).setLabel((String)object5.get(string2, String.class).get());
            object = this.getStyleClass((DXRow)object5);
            if (object != null) {
                ((LocatedVertex)((Object)hashMap)).setStyleClass((String)object);
            }
            hashMap2.put(object22, hashMap);
        }
        for (Object object5 : observableListValue) {
            object3 = (String)object5.get("Type", String.class).get();
            if (!((String)object3).equals("EDGE")) continue;
            object22 = (String)object5.get(string, String.class).get();
            hashMap = (String)object5.get(string3, String.class).get();
            object = null;
            Map map = (Map)object42.get(object22);
            if (map != null) {
                object = (LocatedEdge)map.remove(hashMap);
            }
            if (object != null) continue;
            LocatedVertex locatedVertex = (LocatedVertex)hashMap2.get(object22);
            LocatedVertex locatedVertex2 = (LocatedVertex)hashMap2.get(hashMap);
            object = this.createEdge(locatedVertex, locatedVertex2, (DXRow)object5);
            ((GraphObject)object).setValue(object5);
            String string4 = this.getStyleClass((DXRow)object5);
            if (string4 != null) {
                ((LocatedEdge)object).setStyleClass(string4);
            }
            observableList2.add(object);
        }
        for (Object object5 : object42.values()) {
            for (Object object22 : object5.values()) {
                observableList2.remove(object22);
            }
        }
    }

    private Region createPanel(PanelFactory panelFactory, DXRow dXRow, String string) {
        PanelFactory.Instance instance = panelFactory.createPanel(new MarkerValues(dXRow));
        if (string != null) {
            ((Region)instance.getPanel()).getStyleClass().add((Object)string);
        }
        instance.start();
        return (Region)instance.getPanel();
    }

    private String getStyleClass(DXRow dXRow) {
        ObjectProperty<String> objectProperty;
        String string = null;
        String string2 = this.getStyleClassColumn();
        if (string2 != null && (objectProperty = dXRow.get(string2, String.class)) != null) {
            string = (String)objectProperty.get();
        }
        return string;
    }
}

