/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.observable;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.SimpleBooleanProperty;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.listener.DXBindEvent;
import oracle.dbtools.raptor.metrics.listener.DXConnectionEvent;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXItemListener;
import oracle.dbtools.raptor.metrics.listener.DXItemUpdateEvent;

abstract class ItemChangeAdapter<T>
implements DXItemListener<T> {
    private final SimpleBooleanProperty connected = new SimpleBooleanProperty();
    private final SimpleBooleanProperty available = new SimpleBooleanProperty();
    private URI registeredItemId;

    ItemChangeAdapter() {
    }

    void registerListener(URI uRI, DXListenerList dXListenerList) {
        if (this.registeredItemId == null) {
            this.registeredItemId = uRI;
            dXListenerList.addItemListener(this.registeredItemId, this.getItemClass(), this);
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "listener already registered");
        }
    }

    void unregisterListener(DXListenerList dXListenerList) {
        if (this.registeredItemId != null) {
            dXListenerList.addItemListener(this.registeredItemId, this.getItemClass(), this);
            this.connected.set(false);
            this.available.set(false);
            this.registeredItemId = null;
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "listener not registered");
        }
    }

    BooleanExpression getConnected() {
        return this.connected;
    }

    BooleanExpression getAvailable() {
        return this.available;
    }

    abstract Class<T> getItemClass();

    abstract void onChange(long var1, T var3);

    boolean isAvailable() {
        return this.available.get();
    }

    void setAvailable() {
        this.available.set(true);
    }

    @Override
    public void onUpdate(DXItemUpdateEvent<T> dXItemUpdateEvent) {
        if (dXItemUpdateEvent.isChanged()) {
            Platform.runLater(() -> {
                try {
                    this.onChange(dXItemUpdateEvent.getTStamp(), dXItemUpdateEvent.getValue());
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error thrown by metrics event handler", runtimeException);
                }
            });
        }
    }

    @Override
    public void onConnect(DXConnectionEvent dXConnectionEvent) {
        Platform.runLater(() -> this.connected.set(true));
    }

    @Override
    public void onDisconnect(DXConnectionEvent dXConnectionEvent) {
        Platform.runLater(() -> this.connected.set(false));
    }

    @Override
    public void onBind(DXBindEvent dXBindEvent) {
    }

    @Override
    public void onBindError(DXError dXError) {
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "error binding '" + dXError.getId() + "'", dXError.getException());
    }

    @Override
    public void onUnbind(DXBindEvent dXBindEvent) {
    }
}

