/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.listener;

import java.net.URI;
import java.util.List;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.DXActivityVisitor;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;

public abstract class EngineObjectChange {
    private final ChangeType changeType;
    private final List<PropertyValue<?>> propertyValues;

    protected EngineObjectChange(ChangeType changeType, List<PropertyValue<?>> list) {
        this.changeType = changeType;
        this.propertyValues = list;
    }

    public abstract URI getFocusId();

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public List<PropertyValue<?>> getPropertyValues() {
        return this.propertyValues;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [ ");
        this.appendValuesToString(stringBuilder);
        stringBuilder.append("]");
        return stringBuilder.toString().trim();
    }

    protected void appendValuesToString(StringBuilder stringBuilder) {
        this.appendNamedValueToString(stringBuilder, "changeType", (Object)this.changeType);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("{");
        for (PropertyValue<?> propertyValue : this.propertyValues) {
            this.appendNamedValueToString(stringBuilder2, propertyValue.getMeta().getName(), propertyValue.getValue());
        }
        stringBuilder2.append("}");
        this.appendNamedValueToString(stringBuilder, "propertyValue", stringBuilder2.toString().trim());
    }

    protected void appendNamedValueToString(StringBuilder stringBuilder, String string, Object object) {
        if (object != null) {
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(object);
            stringBuilder.append(" ");
        }
    }

    protected abstract void accept(DXActivityVisitor var1);
}

