/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.item;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.item.TableItemInstance;
import oracle.dbtools.raptor.metrics.item.TableValue;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;

public class TableItemType
extends ItemType {
    private List<String> keyNames;
    private List<TableValue> keyValues;
    private List<TableValue> tableValueList;
    private Map<String, TableValue> tableValueMap;

    public TableItemType(JobType jobType) {
        super(jobType);
    }

    public List<String> getKeyNames() {
        return this.keyNames;
    }

    public List<TableValue> getKeyValues() {
        return this.keyValues;
    }

    public List<TableValue> getTableValues() {
        return this.tableValueList;
    }

    public TableValue getTableValue(String string) {
        return this.tableValueMap.get(string);
    }

    @Override
    protected ItemInstance createItem(URI uRI) {
        return new TableItemInstance(this, uRI);
    }

    protected Class<DXTableChanges> getChangeClass() {
        return DXTableChanges.class;
    }

    @Override
    protected boolean isColumnRequired() {
        return false;
    }

    void setTableValues(List<TableValue> list, String string) {
        this.tableValueList = new ArrayList<TableValue>();
        this.tableValueMap = new HashMap<String, TableValue>();
        String[] stringArray = list.iterator();
        while (stringArray.hasNext()) {
            String[] stringArray2 = stringArray.next();
            String string2 = stringArray2.getName();
            if (!string2.matches("[A-Za-z][A-Za-z0-9#_]*")) {
                throw new IllegalArgumentException("Invalid table column name '" + string2 + "': names must match '[A-Za-z][A-Za-z0-9]*'");
            }
            this.tableValueList.add((TableValue)stringArray2);
            this.tableValueMap.put(string2, (TableValue)stringArray2);
        }
        this.tableValueList = Collections.unmodifiableList(list);
        this.keyNames = new ArrayList<String>();
        this.keyValues = new ArrayList<TableValue>();
        String[] stringArray3 = stringArray = string != null ? string.split("\\s*,\\s*") : new String[]{};
        if (stringArray.length == 0) {
            throw new DXException("table item type '" + this.getPath() + "' must have at least one key");
        }
        for (String string3 : stringArray) {
            if (string3 == null || string3.isEmpty()) continue;
            TableValue tableValue = this.tableValueMap.get(string3);
            if (tableValue == null) {
                throw new DXException("table item type '" + this.getPath() + "' has non-existent key '" + string3 + "'");
            }
            this.keyNames.add(tableValue.getName());
            this.keyValues.add(tableValue);
        }
        this.keyNames = Collections.unmodifiableList(this.keyNames);
        this.keyValues = Collections.unmodifiableList(this.keyValues);
    }
}

