/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.engine.AbstractTypeObject;
import oracle.dbtools.raptor.metrics.engine.ContainerTypeObject;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.DoubleMetaProperty;
import oracle.dbtools.raptor.metrics.engine.Handle;
import oracle.dbtools.raptor.metrics.engine.IntegerMetaProperty;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.MergeSet;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.OperationType;
import oracle.dbtools.raptor.metrics.engine.ParameterTypes;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.TriggerType;
import oracle.dbtools.raptor.metrics.engine.TypeProperty;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.PropertyValue;
import oracle.dbtools.raptor.metrics.listener.SourceTypeChange;

public abstract class SourceType
extends ContainerTypeObject {
    private Map<String, ItemType> itemTypeMap;
    private ContainerTypeObject.Property<Double> minimumIntervalProperty;
    private ContainerTypeObject.Property<Integer> connectionCountProperty;
    private List<TriggerType> triggerTypes;

    protected SourceType(String string, double d, int n) {
        this.minimumIntervalProperty = (ContainerTypeObject)this.new ContainerTypeObject.Property<Double>(new DoubleMetaProperty(this.getClass(), "minimumInterval", MetricsResources.getString("METRICS_PROPERTY_MINIMUM_CONNECT_INTERVAL"), d){

            @Override
            public void validate(Double d) {
                if (d < 0.0) {
                    throw new IllegalArgumentException("constraint violation");
                }
            }
        });
        this.connectionCountProperty = (ContainerTypeObject)this.new ContainerTypeObject.Property<Integer>(new IntegerMetaProperty(this.getClass(), "connectionCount", MetricsResources.getString("METRICS_PROPERTY_CONNECTION_COUNT"), n){

            @Override
            public void validate(Integer n) {
                if (n < 1 || n > 5) {
                    throw new IllegalArgumentException("constraint violation");
                }
            }
        });
        this.setPath(string);
    }

    public URI getConnectionTypeId() {
        return DXIds.newConnectionTypeId(this.getConnectionTypeName());
    }

    public abstract String getConnectionTypeName();

    public abstract Map<String, ? extends JobType> jobTypeMap();

    public abstract Map<String, ? extends OperationType> operationTypeMap();

    public List<? extends TriggerType> getTriggerTypes() {
        return this.triggerTypes;
    }

    @Override
    public String getCategoryName() {
        return "Source";
    }

    protected abstract ParameterTypes getParameterTypes();

    protected void mergeJobTypes(MergeContext mergeContext) {
        if (this.itemTypeMap() != null) {
            for (JobType jobType : ((SourceType)mergeContext.getSourceType()).jobTypeMap().values()) {
                this.itemTypeMap().putAll(jobType.itemTypeMap());
            }
        }
    }

    protected void demergeJobTypes(MergeContext mergeContext) {
        for (JobType object2 : ((SourceType)mergeContext.getSourceType()).jobTypeMap().values()) {
            for (String string : object2.itemTypeMap().keySet()) {
                this.itemTypeMap().remove(string);
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>(((SourceType)mergeContext.getSourceType()).jobTypeMap().keySet());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.jobTypeMap().remove(string);
        }
    }

    protected void mergeOperationTypes(MergeContext mergeContext) {
    }

    protected void demergeOperationTypes(MergeContext mergeContext) {
        ArrayList<String> arrayList = new ArrayList<String>(((SourceType)mergeContext.getSourceType()).operationTypeMap().keySet());
        for (String string : arrayList) {
            this.operationTypeMap().remove(string);
        }
    }

    @Override
    URI createTypeId(String string) {
        return DXIds.newTypeId(this.getConnectionTypeName(), string);
    }

    protected abstract SourceInstance createSource(String var1, Map<String, String> var2);

    Map<String, ItemType> itemTypeMap() {
        if (this.itemTypeMap == null) {
            this.itemTypeMap = new HashMap<String, ItemType>();
            for (JobType jobType : this.jobTypeMap().values()) {
                this.itemTypeMap.putAll(jobType.itemTypeMap());
            }
        }
        return this.itemTypeMap;
    }

    public ContainerTypeObject.Property<Double> getMinimumInterval() {
        return this.minimumIntervalProperty;
    }

    public ContainerTypeObject.Property<Integer> getConnectionCount() {
        return this.connectionCountProperty;
    }

    @Override
    protected void enumerateProperties(List<TypeProperty<?>> list) {
        list.add(this.minimumIntervalProperty);
        list.add(this.connectionCountProperty);
    }

    SourceInstance newSource(String string, Map<String, String> map) {
        SourceInstance sourceInstance = this.createSource(string, map);
        sourceInstance.start(this.getContext(), this.createInstanceProperties(sourceInstance));
        return sourceInstance;
    }

    void merge(final MergeSet mergeSet) {
        this.mergeJobTypes(new MergeContext(){

            @Override
            public <S extends SourceType> S getSourceType() {
                return (S)mergeSet.getSourceType();
            }
        });
        this.mergeOperationTypes(new MergeContext(){

            @Override
            public <S extends SourceType> S getSourceType() {
                return (S)mergeSet.getSourceType();
            }
        });
        this.triggerTypes.addAll(mergeSet.getSourceType().triggerTypes);
    }

    void demerge(final MergeSet mergeSet) {
        this.demergeJobTypes(new MergeContext(){

            @Override
            public <S extends SourceType> S getSourceType() {
                return (S)mergeSet.getSourceType();
            }
        });
        this.demergeOperationTypes(new MergeContext(){

            @Override
            public <S extends SourceType> S getSourceType() {
                return (S)mergeSet.getSourceType();
            }
        });
        this.triggerTypes.removeAll(mergeSet.getSourceType().triggerTypes);
    }

    @Override
    AbstractTypeObject getEnclosingType(Class<? extends AbstractTypeObject> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    @Override
    SourceInstance findInstance(ObjectManager objectManager, Handle handle) {
        return objectManager.getSource(handle);
    }

    void setTriggerTypes(List<TriggerType> list) {
        this.triggerTypes = list;
    }

    void setHardDefaultMinimumInterval(double d) {
        this.minimumIntervalProperty = (ContainerTypeObject)this.new ContainerTypeObject.Property<Double>(new DoubleMetaProperty(this.getClass(), "minimumInterval", MetricsResources.getString("METRICS_PROPERTY_MINIMUM_CONNECT_INTERVAL"), d){

            @Override
            public void validate(Double d) {
                if (d < 0.0) {
                    throw new IllegalArgumentException("constraint violation");
                }
            }
        });
    }

    void setHardDefaultConnectionCount(int n) {
        this.connectionCountProperty = (ContainerTypeObject)this.new ContainerTypeObject.Property<Integer>(new IntegerMetaProperty(this.getClass(), "connectionCount", MetricsResources.getString("METRICS_PROPERTY_CONNECTION_COUNT"), n){

            @Override
            public void validate(Integer n) {
                if (n < 1 || n > 5) {
                    throw new IllegalArgumentException("constraint violation");
                }
            }
        });
    }

    @Override
    protected SourceTypeChange createChangeObject(ChangeType changeType, List<PropertyValue<?>> list) {
        return new SourceTypeChange(changeType, this.getTypeId(), list);
    }

    protected abstract class MergeContext {
        protected MergeContext() {
        }

        public abstract <S extends SourceType> S getSourceType();
    }
}

