/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.ParameterType;
import oracle.dbtools.raptor.metrics.engine.ValueConverter;

public class ParameterTypes {
    private final Map<String, ParameterType> parameterTypeMap = new HashMap<String, ParameterType>();

    public ParameterTypes(Collection<ParameterType> collection) {
        for (ParameterType parameterType : collection) {
            this.parameterTypeMap.put(parameterType.getName(), parameterType);
        }
    }

    public Collection<String> getParameterNames() {
        return this.parameterTypeMap.keySet();
    }

    public ParameterType getParameterType(String string) {
        return this.parameterTypeMap.get(string);
    }

    Map<String, String> normalize(Map<String, String> map) {
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        for (String object : map.keySet()) {
            if (this.parameterTypeMap.containsKey(object)) continue;
            return null;
        }
        for (ParameterType parameterType : this.parameterTypeMap.values()) {
            if (parameterType.normalize(map)) continue;
            return null;
        }
        return map;
    }

    Map<String, Object> convertToRaw(ValueConverter valueConverter, Map<String, String> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this.parameterTypeMap.keySet()) {
            Object object = this.parameterTypeMap.get(string).convertToRaw(valueConverter, map);
            hashMap.put(string, object);
        }
        return hashMap;
    }
}

