/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.AbstractEngineObject;
import oracle.dbtools.raptor.metrics.engine.AbstractTypeObject;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.EngineObjectProperty;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.Handle;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.ItemType;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.JobType;
import oracle.dbtools.raptor.metrics.engine.MergeSet;
import oracle.dbtools.raptor.metrics.engine.OperationInstance;
import oracle.dbtools.raptor.metrics.engine.OperationType;
import oracle.dbtools.raptor.metrics.engine.ParameterTypes;
import oracle.dbtools.raptor.metrics.engine.RunnableInstance;
import oracle.dbtools.raptor.metrics.engine.RunnableType;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.engine.SourceType;
import oracle.dbtools.raptor.metrics.engine.TracingService;
import oracle.dbtools.raptor.metrics.engine.TriggerType;
import oracle.dbtools.raptor.metrics.listener.ChangeType;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;
import oracle.dbtools.raptor.support.MetaURLReference;

class ObjectManager {
    private Context context;
    private final Map<URL, MergeSet> mergeSetMap = new HashMap<URL, MergeSet>();
    private final Map<URI, AbstractTypeObject> typeObjectMap = new HashMap<URI, AbstractTypeObject>();
    private final Set<SourceType> sourceTypes = new HashSet<SourceType>();
    private final Map<URI, SourceInstance> sourceMap = new HashMap<URI, SourceInstance>();
    private final Map<URI, List<TriggerType>> triggerTypeMap = new HashMap<URI, List<TriggerType>>();
    private final List<Runnable> purgeActions = new ArrayList<Runnable>();

    ObjectManager() {
    }

    void setContext(Context context) {
        this.context = context;
    }

    Handle createHandle(final URI uRI) {
        return new Handle(uRI){
            private boolean loadedConnectionParameters;
            private Map<String, String> normalizedConnectionParameters;
            private boolean loadedQueryParameters;
            private Map<String, String> normalizedQueryParameters;
            private String enclosingSourcePath;

            @Override
            String getEnclosingSourcePath() {
                if (this.enclosingSourcePath == null) {
                    SourceType sourceType = ObjectManager.this.getCanonicalTypeObject(SourceType.class, this);
                    this.enclosingSourcePath = sourceType.getPath();
                }
                return this.enclosingSourcePath;
            }

            @Override
            Map<String, String> getNormalizedConnectionParameters() {
                if (!this.loadedConnectionParameters) {
                    Map<String, String> map = DXIds.getConnectionParameters(uRI);
                    if (map != null) {
                        SourceType sourceType = ObjectManager.this.getCanonicalTypeObject(SourceType.class, this);
                        this.normalizedConnectionParameters = sourceType.getParameterTypes().normalize(map);
                    }
                    this.loadedConnectionParameters = true;
                }
                return this.normalizedConnectionParameters;
            }

            @Override
            Map<String, String> getNormalizedQueryParameters() {
                if (!this.loadedQueryParameters) {
                    ParameterTypes parameterTypes;
                    RunnableType runnableType;
                    Map<String, String> map = DXIds.getQueryParameters(uRI);
                    if (map != null && (runnableType = ObjectManager.this.getCanonicalTypeObject(RunnableType.class, this)) != null && (parameterTypes = runnableType.getParameterTypes()) != null) {
                        this.normalizedQueryParameters = parameterTypes.normalize(map);
                    }
                    this.loadedQueryParameters = true;
                }
                return this.normalizedQueryParameters;
            }
        };
    }

    boolean isEngineActive() {
        return !this.sourceMap.isEmpty();
    }

    Collection<SourceType> getSourceTypes() {
        return this.sourceTypes;
    }

    Collection<SourceInstance> getSources() {
        return this.sourceMap.values();
    }

    <T> EngineObjectProperty<T> getProperty(Handle handle, Class<T> clazz, String string) {
        EngineObjectProperty<T> engineObjectProperty;
        if (handle.isType()) {
            AbstractTypeObject abstractTypeObject = this.typeObjectMap.get(handle.getId());
            engineObjectProperty = abstractTypeObject.getProperty(clazz, string);
        } else {
            AbstractTypeObject abstractTypeObject = this.typeObjectMap.get(handle.getTypeId());
            engineObjectProperty = abstractTypeObject.getInstanceProperty(handle.getId(), clazz, string);
        }
        return engineObjectProperty;
    }

    <T extends AbstractTypeObject> T getCanonicalTypeObject(Class<T> clazz, Handle handle) {
        AbstractTypeObject abstractTypeObject = handle.isType() ? this.typeObjectMap.get(handle.getId()) : this.typeObjectMap.get(handle.getTypeId());
        return (T)abstractTypeObject.getEnclosingType(clazz);
    }

    SourceInstance getEnclosingSourceInstance(Handle handle) {
        URI uRI = handle.getEnclosingSourceId();
        return this.sourceMap.get(uRI);
    }

    SourceType getSourceType(Handle handle) {
        return (SourceType)this.typeObjectMap.get(handle.getId());
    }

    SourceInstance getSource(Handle handle) {
        return this.sourceMap.get(handle.getId());
    }

    JobType getJobType(Handle handle) {
        return (JobType)this.typeObjectMap.get(handle.getId());
    }

    JobInstance getJob(Handle handle) {
        JobType jobType = (JobType)this.typeObjectMap.get(handle.getTypeId());
        if (jobType != null) {
            return jobType.findInstance(this, handle);
        }
        return null;
    }

    ItemType getItemType(Handle handle) {
        return (ItemType)this.typeObjectMap.get(handle.getId());
    }

    ItemInstance getItem(Handle handle) {
        ItemType itemType = (ItemType)this.typeObjectMap.get(handle.getTypeId());
        if (itemType != null) {
            return itemType.findInstance(this, handle);
        }
        return null;
    }

    OperationType getOperationType(Handle handle) {
        return (OperationType)this.typeObjectMap.get(handle.getId());
    }

    OperationInstance getOperation(Handle handle) {
        OperationType operationType = (OperationType)this.typeObjectMap.get(handle.getTypeId());
        if (operationType != null) {
            return operationType.findInstance(this, handle);
        }
        return null;
    }

    RunnableType getRunnableType(Handle handle) {
        return (RunnableType)this.typeObjectMap.get(handle.getId());
    }

    RunnableInstance getRunnable(Handle handle) {
        RunnableType runnableType = (RunnableType)this.typeObjectMap.get(handle.getTypeId());
        if (runnableType != null) {
            return runnableType.findInstance(this, handle);
        }
        return null;
    }

    String getCategoryName(Handle handle) {
        AbstractTypeObject abstractTypeObject = this.typeObjectMap.get(handle.getTypeId());
        if (abstractTypeObject != null) {
            return abstractTypeObject.getCategoryName();
        }
        return null;
    }

    ItemInstance getOrCreateItem(Handle handle, Class<?> clazz) {
        ItemType itemType = (ItemType)this.typeObjectMap.get(handle.getTypeId());
        if (itemType != null) {
            AbstractEngineObject abstractEngineObject = itemType.findInstance(this, handle);
            if (abstractEngineObject == null) {
                AbstractEngineObject abstractEngineObject2;
                Handle handle2 = this.createHandle(handle.getEnclosingSourceId());
                boolean bl = false;
                SourceInstance sourceInstance = this.getSource(handle2);
                if (sourceInstance == null) {
                    abstractEngineObject2 = (SourceType)this.typeObjectMap.get(handle2.getTypeId());
                    sourceInstance = abstractEngineObject2.newSource(handle2.getConnectionName(), handle2.getNormalizedConnectionParameters());
                    bl = true;
                }
                abstractEngineObject2 = null;
                if (sourceInstance != null) {
                    abstractEngineObject2 = sourceInstance.getOrCreateItem(handle.getPath(), handle.getNormalizedQueryParameters(), clazz);
                }
                if (abstractEngineObject2 != null) {
                    if (bl) {
                        TracingService tracingService = this.context.getTracingService();
                        if (this.sourceMap.isEmpty() && tracingService.isTracingEnabled()) {
                            tracingService.traceEngineEvent("onEngineActivated");
                        }
                        this.sourceMap.put(handle2.getId(), sourceInstance);
                    }
                    abstractEngineObject = abstractEngineObject2;
                }
            }
            return abstractEngineObject;
        }
        return null;
    }

    OperationInstance createOperation(Handle handle, DXOperationCallback dXOperationCallback) {
        OperationType operationType = (OperationType)this.typeObjectMap.get(handle.getTypeId());
        if (operationType != null) {
            if (operationType.findInstance(this, handle) != null) {
                dXOperationCallback.onComplete(new DXError(handle.getId(), new DXException("operation is already running")));
            } else {
                AbstractEngineObject abstractEngineObject;
                Handle handle2 = this.createHandle(handle.getEnclosingSourceId());
                boolean bl = false;
                SourceInstance sourceInstance = this.getSource(handle2);
                if (sourceInstance == null) {
                    abstractEngineObject = (SourceType)this.typeObjectMap.get(handle2.getTypeId());
                    sourceInstance = abstractEngineObject.newSource(handle2.getConnectionName(), handle2.getNormalizedConnectionParameters());
                    bl = true;
                }
                abstractEngineObject = null;
                if (sourceInstance != null) {
                    abstractEngineObject = sourceInstance.createOperation(handle.getPath(), handle.getNormalizedQueryParameters(), dXOperationCallback);
                }
                if (abstractEngineObject != null) {
                    if (bl) {
                        TracingService tracingService = this.context.getTracingService();
                        if (this.sourceMap.isEmpty() && tracingService.isTracingEnabled()) {
                            tracingService.traceEngineEvent("onEngineActivated");
                        }
                        this.sourceMap.put(handle2.getId(), sourceInstance);
                    }
                    return abstractEngineObject;
                }
            }
        }
        return null;
    }

    void removeSource(SourceInstance sourceInstance) {
        this.addPurgeAction(() -> {
            URI uRI = sourceInstance.getId();
            if (this.sourceMap.remove(uRI) != null) {
                this.checkRemoveSourceType(sourceInstance.getSourceType());
            } else {
                this.context.getLogger().log(Level.WARNING, "Source not known: {0}", uRI);
            }
        });
    }

    void purgeRemovedObjects() {
        for (int i = 0; i < this.purgeActions.size(); ++i) {
            this.purgeActions.get(i).run();
        }
        this.purgeActions.clear();
    }

    void invokeTriggers(RunnableInstance runnableInstance) {
        URI uRI = runnableInstance.getRunnableType().getTypeId();
        List<TriggerType> list = this.triggerTypeMap.get(uRI);
        if (list != null) {
            URI uRI2 = runnableInstance.getId();
            String string = DXIds.getConnectionTypeName(uRI2);
            String string2 = DXIds.getConnectionName(uRI2);
            ExecutionService executionService = this.context.getExecutionService();
            for (TriggerType triggerType : list) {
                URI uRI3 = DXIds.newId(string, string2, triggerType.getJobPath());
                JobInstance jobInstance = this.getJob(this.createHandle(uRI3));
                if (jobInstance == null) continue;
                executionService.addEvent(jobInstance.getAutomaton().createRequestRun());
            }
        }
    }

    void useMergeSet(MetaURLReference metaURLReference) {
        URL uRL = metaURLReference.getURL();
        MergeSet mergeSet = this.mergeSetMap.get(uRL);
        if (mergeSet != null) {
            mergeSet.addUse();
        } else {
            try {
                this.mergeTypes(new MergeSet(metaURLReference));
            }
            catch (RuntimeException runtimeException) {
                this.context.getLogger().log(Level.SEVERE, "unable to merge definition file '" + uRL + "'", runtimeException);
            }
        }
    }

    void releaseMergeSet(MetaURLReference metaURLReference) {
        URL uRL = metaURLReference.getURL();
        MergeSet mergeSet = this.mergeSetMap.get(uRL);
        if (mergeSet != null) {
            mergeSet.releaseUse(() -> this.deferDemergeTypes(mergeSet));
        }
    }

    void releaseMergeSetRunnable(RunnableInstance runnableInstance) {
        MergeSet mergeSet = runnableInstance.getRunnableType().getMergeSet();
        if (mergeSet != null) {
            mergeSet.releaseRunnable(() -> this.deferDemergeTypes(mergeSet));
        }
    }

    private void addPurgeAction(Runnable runnable) {
        this.purgeActions.add(runnable);
    }

    private void deferDemergeTypes(MergeSet mergeSet) {
        this.addPurgeAction(() -> this.demergeTypes(mergeSet));
    }

    /*
     * WARNING - void declaration
     */
    private void mergeTypes(MergeSet mergeSet) {
        Object object;
        SourceType sourceType = mergeSet.getSourceType();
        sourceType.onMerge(this.context, mergeSet);
        URI uRI = sourceType.getTypeId();
        SourceType sourceType2 = (SourceType)this.typeObjectMap.get(uRI);
        HashMap<Object, AbstractTypeObject> hashMap = new HashMap<Object, AbstractTypeObject>();
        HashSet<URI> hashSet = new HashSet<URI>();
        if (sourceType2 == null) {
            this.verifyObjectID(this.typeObjectMap, hashSet, uRI);
            hashMap.put(uRI, sourceType);
        } else {
            if (sourceType.getClass() != sourceType2.getClass()) {
                throw new IllegalArgumentException("Merge type conflict: " + uRI);
            }
            hashSet.add(uRI);
            for (JobType abstractTypeObject : sourceType2.jobTypeMap().values()) {
                hashSet.add(abstractTypeObject.getTypeId());
                for (ItemType itemType : abstractTypeObject.itemTypeMap().values()) {
                    hashSet.add(itemType.getTypeId());
                }
            }
            for (OperationType operationType : sourceType2.operationTypeMap().values()) {
                hashSet.add(operationType.getTypeId());
            }
        }
        if (sourceType2 == null) {
            this.context.getActivityListenerService().addEngineObjectChange(sourceType, ChangeType.ADD);
        }
        for (JobType jobType : sourceType.jobTypeMap().values()) {
            jobType.onMerge(this.context, mergeSet);
            object = jobType.getTypeId();
            this.verifyObjectID(this.typeObjectMap, hashSet, (URI)object);
            hashMap.put(object, jobType);
            this.context.getActivityListenerService().addEngineObjectChange(jobType, ChangeType.ADD);
            for (ItemType itemType : jobType.itemTypeMap().values()) {
                URI uRI2 = itemType.getTypeId();
                this.verifyObjectID(this.typeObjectMap, hashSet, uRI2);
                hashMap.put(uRI2, itemType);
                this.context.getActivityListenerService().addEngineObjectChange(itemType, ChangeType.ADD);
            }
        }
        for (OperationType operationType : sourceType.operationTypeMap().values()) {
            operationType.onMerge(this.context, mergeSet);
            object = operationType.getTypeId();
            this.verifyObjectID(this.typeObjectMap, hashSet, (URI)object);
            hashMap.put(object, operationType);
            this.context.getActivityListenerService().addEngineObjectChange(operationType, ChangeType.ADD);
        }
        for (TriggerType triggerType : sourceType.getTriggerTypes()) {
            void var10_24;
            object = triggerType.getTriggerObjectTypeId();
            List<TriggerType> list = this.triggerTypeMap.get(object);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                this.triggerTypeMap.put((URI)object, arrayList);
            }
            var10_24.add(triggerType);
            this.context.getActivityListenerService().addEngineObjectChange(triggerType, ChangeType.ADD);
        }
        this.typeObjectMap.putAll(hashMap);
        if (sourceType2 == null) {
            this.sourceTypes.add(sourceType);
        } else {
            sourceType2.merge(mergeSet);
        }
        this.mergeSetMap.put(mergeSet.getURL(), mergeSet);
        this.context.getLogger().log(Level.INFO, "merged jobs from ''{0}''", mergeSet.getURL().toString());
    }

    private void demergeTypes(MergeSet mergeSet) {
        SourceType sourceType = mergeSet.getSourceType();
        URI uRI = sourceType.getTypeId();
        for (JobType abstractTypeObject : sourceType.jobTypeMap().values()) {
            this.typeObjectMap.remove(abstractTypeObject.getTypeId());
            for (ItemType itemType : abstractTypeObject.itemTypeMap().values()) {
                this.typeObjectMap.remove(itemType.getTypeId());
                this.context.getActivityListenerService().addEngineObjectChange(itemType, ChangeType.REMOVE);
            }
            this.context.getActivityListenerService().addEngineObjectChange(abstractTypeObject, ChangeType.REMOVE);
        }
        for (OperationType operationType : sourceType.operationTypeMap().values()) {
            this.typeObjectMap.remove(operationType.getTypeId());
            this.context.getActivityListenerService().addEngineObjectChange(operationType, ChangeType.REMOVE);
        }
        for (TriggerType triggerType : sourceType.getTriggerTypes()) {
            URI uRI2 = triggerType.getTriggerObjectTypeId();
            List<TriggerType> list = this.triggerTypeMap.get(uRI2);
            list.remove(triggerType);
            this.context.getActivityListenerService().addEngineObjectChange(triggerType, ChangeType.REMOVE);
        }
        SourceType sourceType2 = (SourceType)this.typeObjectMap.get(uRI);
        if (sourceType2 != null) {
            sourceType2.demerge(mergeSet);
            this.checkRemoveSourceType(sourceType2);
        }
        this.mergeSetMap.remove(mergeSet.getURL());
        this.context.getLogger().log(Level.INFO, "demerged jobs from ''{0}''", mergeSet.getURL().toString());
    }

    private void checkRemoveSourceType(SourceType sourceType) {
        if (sourceType.jobTypeMap().isEmpty() && sourceType.operationTypeMap().isEmpty()) {
            boolean bl = false;
            for (SourceInstance sourceInstance : this.sourceMap.values()) {
                if (sourceInstance.getSourceType() != sourceType) continue;
                bl = true;
            }
            if (!bl) {
                this.context.getActivityListenerService().addEngineObjectChange(sourceType, ChangeType.REMOVE);
                this.addPurgeAction(() -> {
                    this.typeObjectMap.remove(sourceType.getTypeId());
                    this.sourceTypes.remove(sourceType);
                });
            }
        }
    }

    private void verifyObjectID(Map<URI, ?> map, Set<URI> set, URI uRI) {
        String string = DXIds.getPath(uRI);
        if (!string.matches("([A-Za-z][A-Za-z0-9]*)(/[A-Za-z][A-Za-z0-9]*)*")) {
            throw new IllegalArgumentException("Invalid path name '" + string + "': names must match '([A-Za-z][A-Za-z0-9]*)(/[A-Za-z][A-Za-z0-9]*)*'");
        }
        if (!set.add(uRI) || map.containsKey(uRI)) {
            throw new IllegalArgumentException("Duplicate ID: " + uRI);
        }
    }
}

