/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.net.URI;
import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.DXIds;

abstract class Handle {
    private final URI id;
    private Boolean isType;
    private URI typeId;
    private String connectionTypeName;
    private String connectionName;
    private String path;
    private URI canonicalSourceTypeId;
    private boolean loadedEnclosingSourceId;
    private URI enclosingSourceId;

    Handle(URI uRI) {
        this.id = uRI;
    }

    URI getId() {
        return this.id;
    }

    boolean isType() {
        if (this.isType == null) {
            this.isType = DXIds.isTypeId(this.id);
        }
        return this.isType;
    }

    URI getTypeId() {
        if (this.typeId == null && !this.isType()) {
            this.typeId = DXIds.getTypeId(this.id);
        }
        return this.typeId;
    }

    String getConnectionTypeName() {
        if (this.connectionTypeName == null) {
            this.connectionTypeName = DXIds.getConnectionTypeName(this.id);
        }
        return this.connectionTypeName;
    }

    String getConnectionName() {
        if (this.connectionName == null && !this.isType()) {
            this.connectionName = DXIds.getConnectionName(this.id);
        }
        return this.connectionName;
    }

    String getPath() {
        if (this.path == null) {
            this.path = DXIds.getPath(this.id);
        }
        return this.path;
    }

    URI getCanonicalSourceTypeId() {
        if (this.canonicalSourceTypeId == null) {
            this.canonicalSourceTypeId = DXIds.newTypeId(this.getConnectionTypeName(), this.getEnclosingSourcePath());
        }
        return this.canonicalSourceTypeId;
    }

    URI getEnclosingSourceId() {
        if (!this.loadedEnclosingSourceId && !this.isType()) {
            this.enclosingSourceId = DXIds.newId(this.getConnectionTypeName(), this.getConnectionName(), this.getEnclosingSourcePath(), this.getNormalizedConnectionParameters(), null);
            this.loadedEnclosingSourceId = true;
        }
        return this.enclosingSourceId;
    }

    abstract String getEnclosingSourcePath();

    abstract Map<String, String> getNormalizedConnectionParameters();

    abstract Map<String, String> getNormalizedQueryParameters();
}

