/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import oracle.dbtools.raptor.metrics.engine.Command;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;

abstract class CallbackCommand
extends Command {
    private final Context context;
    private final DXOperationCallback callback;

    CallbackCommand(Context context, DXOperationCallback dXOperationCallback) {
        this.context = context;
        this.callback = dXOperationCallback;
    }

    @Override
    void execute() {
        DXException dXException = null;
        try {
            this.executeImpl();
        }
        catch (DXException dXException2) {
            dXException = dXException2;
        }
        catch (RuntimeException runtimeException) {
            dXException = new DXException(runtimeException);
        }
        if (this.callback != null) {
            final DXError dXError = new DXError(null, dXException);
            this.context.getExecutionService().addNotification(new Notification(){

                @Override
                void execute() {
                    CallbackCommand.this.callback.onComplete(dXError);
                }
            });
        }
    }

    abstract void executeImpl();
}

