/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import javafx.beans.DefaultProperty;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import oracle.dbtools.raptor.metrics.dataobject.ArithmeticDataObject;
import oracle.dbtools.raptor.metrics.dataobject.NumberDataObject;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;

@DefaultProperty(value="items")
public abstract class CollectionArithmeticDataObject
extends ArithmeticDataObject {
    private final ObservableList<NumberDataObject> items = FXCollections.observableArrayList();
    private BooleanExpression available;
    private BooleanExpression connected;

    public ObservableList<NumberDataObject> getItems() {
        return this.items;
    }

    @Override
    public BooleanExpression getConnected() {
        return this.connected;
    }

    @Override
    public BooleanExpression getAvailable() {
        return this.available;
    }

    @Override
    public void initialize() {
        for (NumberDataObject numberDataObject : this.items) {
            numberDataObject.initialize();
            if (this.available == null) {
                this.available = numberDataObject.getAvailable();
                this.connected = numberDataObject.getConnected();
                continue;
            }
            this.available = Bindings.and((ObservableBooleanValue)this.available, (ObservableBooleanValue)numberDataObject.getAvailable());
            this.connected = Bindings.and((ObservableBooleanValue)this.connected, (ObservableBooleanValue)numberDataObject.getConnected());
        }
        super.initialize();
    }

    @Override
    public void registerListener(String string, DXListenerList dXListenerList) {
        for (NumberDataObject numberDataObject : this.items) {
            numberDataObject.registerListener(string, dXListenerList);
        }
    }

    @Override
    public void unregisterListener(DXListenerList dXListenerList) {
        for (NumberDataObject numberDataObject : this.items) {
            numberDataObject.unregisterListener(dXListenerList);
        }
    }
}

