/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.dataobject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import oracle.dbtools.raptor.metrics.dataobject.Bind;

public abstract class AnyVar {
    private static final Map<Object, Bind<?>> bindMap = new WeakHashMap();

    protected static void addAtomicBind(Object object, Bind bind) {
        Property<?> property = ((AnyVar)bind.getSource()).getProperty();
        Property property2 = (Property)AnyVar.getTargetObject(object, AnyVar.getPropertyMethodName(bind));
        property2.bindBidirectional(property);
        bindMap.put(object, bind);
    }

    protected static void addListBind(Object object, Bind bind) {
        ObservableList observableList = (ObservableList)((AnyVar)bind.getSource()).getProperty().getValue();
        ObservableList observableList2 = (ObservableList)AnyVar.getTargetObject(object, AnyVar.getCollectionMethodName(bind));
        Bindings.bindContentBidirectional((ObservableList)observableList2, (ObservableList)observableList);
        bindMap.put(object, bind);
    }

    protected static void addMapBind(Object object, Bind bind) {
        ObservableMap observableMap = (ObservableMap)((AnyVar)bind.getSource()).getProperty().getValue();
        ObservableMap observableMap2 = (ObservableMap)AnyVar.getTargetObject(object, AnyVar.getCollectionMethodName(bind));
        Bindings.bindContentBidirectional((ObservableMap)observableMap2, (ObservableMap)observableMap);
        bindMap.put(object, bind);
    }

    protected static void addSetBind(Object object, Bind bind) {
        ObservableSet observableSet = (ObservableSet)((AnyVar)bind.getSource()).getProperty().getValue();
        ObservableSet observableSet2 = (ObservableSet)AnyVar.getTargetObject(object, AnyVar.getCollectionMethodName(bind));
        Bindings.bindContentBidirectional((ObservableSet)observableSet2, (ObservableSet)observableSet);
        bindMap.put(object, bind);
    }

    private static String getPropertyMethodName(Bind bind) {
        return bind.getTarget() + "Property";
    }

    private static String getCollectionMethodName(Bind bind) {
        String string = bind.getTarget();
        return "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static <T> T getTargetObject(Object object, String string) {
        Object object2;
        try {
            Method method = object.getClass().getMethod(string, new Class[0]);
            object2 = method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException("binding", exception);
        }
        return (T)object2;
    }

    public abstract Property<?> getProperty();

    public String toStringRep() {
        Object object;
        Property<?> property = this.getProperty();
        if (property != null && (object = property.getValue()) != null) {
            return object.toString();
        }
        return "";
    }
}

