/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.List;
import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.control.AreaComponent;

public class RegionComponent
extends AreaComponent {
    private final StackPane region;

    public RegionComponent(Region region) {
        this.region = new StackPane(new Node[]{region}){

            protected void layoutChildren() {
                ((Node)this.getChildren().get(0)).resize(this.getWidth(), this.getHeight());
            }
        };
        this.region.setMaxWidth(region.getMaxWidth());
        this.region.setMinWidth(region.getMinWidth());
        this.region.setPrefWidth(region.getPrefWidth());
        this.region.setMaxHeight(region.getMaxHeight());
        this.region.setMinHeight(region.getMinHeight());
        this.region.setPrefHeight(region.getPrefHeight());
    }

    @Override
    public double getHeight() {
        return this.region.prefHeight(-1.0);
    }

    @Override
    public double getWidth() {
        return this.region.prefWidth(-1.0);
    }

    @Override
    public void setHeight(double d) {
        this.region.setPrefHeight(d);
    }

    @Override
    public void setWidth(double d) {
        this.region.setPrefWidth(d);
    }

    public Region getNode() {
        return this.region;
    }

    @Override
    protected void doMove() {
        this.resize();
        this.region.setLayoutX(this.getX());
        this.region.setLayoutY(this.getY());
    }

    @Override
    protected void doAnimate(Timeline timeline, Duration duration, EventHandler<ActionEvent> eventHandler) {
        this.resize();
        this.addKeyFrame(timeline, duration, this.region.layoutXProperty(), this.getX());
        this.addKeyFrame(timeline, duration, eventHandler, this.region.layoutYProperty(), this.getY());
    }

    @Override
    void addNodeTo(List<Node> list) {
        super.addNodeTo(list);
        this.region.applyCss();
        this.region.layout();
    }

    private double getX() {
        return this.getCenterX() - 0.5 * this.getWidth();
    }

    private double getY() {
        return this.getCenterY() - 0.5 * this.getHeight();
    }

    private void resize() {
        double d = Math.min(this.getWidth(), this.region.maxWidth(-1.0));
        double d2 = Math.min(this.getHeight(), this.region.maxHeight(-1.0));
        this.region.resize(d, d2);
    }
}

